/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.ammo.bullets;

import java.awt.Color;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.HandGunBulletProjectile;
import necesse.gfx.GameColor;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemCategory;
import necesse.inventory.item.bulletItem.BulletItem;

public class ModularBullet
extends BulletItem {
    public int damage;
    public int armorPen;
    public float critChance;

    public ModularBullet(int stackAmount) {
        super(5000);
        this.setItemCategory(new String[]{"equipment", "ammo"});
        this.setItemCategory(ItemCategory.craftingManager, new String[]{"equipment", "ammo"});
        this.keyWords.add("bullet");
    }

    public ModularBullet() {
        this(5000);
        this.damage = 1;
        this.rarity = Item.Rarity.EPIC;
    }

    protected ListGameTooltips getDisplayNameTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        if (!item.getGndData().hasKey("HeadItem")) {
            tooltips.add((Object)new StringTooltips("Bullet Template", new Color(255, 255, 255)));
            tooltips.add((Object)new StringTooltips("I see you cheating :)", new Color(255, 0, 0)));
        } else {
            GameColor tiercolor = GameColor.ITEM_NORMAL;
            tooltips.add((Object)new StringTooltips(Localization.translate((String)"item", (String)(item.getGndData().getString("HeadItem") + "Name")) + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("EndItem") + "Name")) + " " + Localization.translate((String)"item", (String)this.getStringID()), tiercolor));
        }
        return tooltips;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = this.getBaseTooltips(item, perspective, blackboard);
        if (!item.getGndData().hasKey("HeadItem")) {
            return tooltips;
        }
        InventoryItem headItem = ItemRegistry.getItem((String)item.getGndData().getString("HeadItem", "debug")).getDefaultItem(perspective, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "debug")).getDefaultItem(perspective, 1);
        InventoryItem endItem = ItemRegistry.getItem((String)item.getGndData().getString("EndItem", "debug")).getDefaultItem(perspective, 1);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"damagetip", (String)"value", (Object)Float.valueOf(((float)this.damage + headItem.getGndData().getFloat("BaseDamage", 0.0f) + bodyItem.getGndData().getFloat("BaseDamage", 0.0f) + endItem.getGndData().getFloat("BaseDamage", 0.0f)) * headItem.getGndData().getFloat("DamageMod", 1.0f) * bodyItem.getGndData().getFloat("DamageMod", 1.0f) * endItem.getGndData().getFloat("DamageMod", 1.0f))));
        if (headItem.getGndData().hasKey("Tooltip")) {
            tooltips.add(Localization.translate((String)"bullettooltip", (String)headItem.getGndData().getString("Tooltip", "debug")));
        }
        if (bodyItem.getGndData().hasKey("Tooltip")) {
            tooltips.add(Localization.translate((String)"bullettooltip", (String)bodyItem.getGndData().getString("Tooltip", "debug")));
        }
        if (endItem.getGndData().hasKey("Tooltip")) {
            tooltips.add(Localization.translate((String)"bullettooltip", (String)endItem.getGndData().getString("Tooltip", "debug")));
        }
        if (Control.INV_QUICK_TRASH.isDown()) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Tip") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("HeadItem") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Primer") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Shell") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("EndItem") + "Name")));
        } else if (Control.INV_QUICK_MOVE.isDown()) {
            tooltips.add(Localization.translate((String)"bullettooltip", (String)"HeadTip"));
            tooltips.add(Localization.translate((String)"bullettooltip", (String)(item.getGndData().getString("HeadItem") + "Tip")));
            tooltips.add(Localization.translate((String)"bullettooltip", (String)"BodyTip"));
            tooltips.add(Localization.translate((String)"bullettooltip", (String)(item.getGndData().getString("BodyItem") + "Tip")));
            tooltips.add(Localization.translate((String)"bullettooltip", (String)"EndTip"));
            tooltips.add(Localization.translate((String)"bullettooltip", (String)(item.getGndData().getString("EndItem") + "Tip")));
        } else {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdShift", (String)"shift", (String)"invquickmove"));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdCtrl", (String)"ctrl", (String)"invtrash"));
        }
        return tooltips;
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("HeadItem", "BarrelShotgunIron")))).initDraw().color(color).size(size).depth(-1.0f).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("EndItem", "StockShotgunIron")))).initDraw().color(color).size(size).draw(x, y);
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        return new GameSprite(GameTexture.fromFile((String)"items/simplebullet"));
    }

    public InventoryItem getBulletItem(PlayerMob player) {
        InventoryItem invItem = null;
        if (player.getFirstAvailableBullet("debug").getStringID().equalsIgnoreCase(this.getStringID())) {
            for (int i = 0; i <= player.getInv().main.getSize(); ++i) {
                InventoryItem slot = player.getInv().main.getItem(i);
                if (player.getInv().main.getItem(i) == null || player.getInv().main.getItem((int)i).item != player.getFirstAvailableBullet("debug")) continue;
                invItem = player.getInv().main.getItem(i);
                return invItem;
            }
        } else {
            invItem = new InventoryItem((Item)this, 1);
            return invItem;
        }
        return invItem;
    }

    public float getAmmoConsumeChance() {
        return 1.0f;
    }

    public GameDamage modDamage(GameDamage damage) {
        return damage.add((float)this.damage, this.armorPen, this.critChance);
    }

    public float modVelocity(float velocity) {
        return velocity;
    }

    public int modRange(int range) {
        return range;
    }

    public int modKnockback(int knockback) {
        return knockback;
    }

    public Projectile getProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage damage, int knockback, Mob owner) {
        if (owner instanceof PlayerMob) {
            InventoryItem bullet = this.getBulletItem((PlayerMob)owner);
            if (bullet != null) {
                InventoryItem headItem = ItemRegistry.getItem((String)bullet.getGndData().getString("HeadItem", "debug")).getDefaultItem(null, 1);
                InventoryItem bodyItem = ItemRegistry.getItem((String)bullet.getGndData().getString("BodyItem", "debug")).getDefaultItem(null, 1);
                InventoryItem endItem = ItemRegistry.getItem((String)bullet.getGndData().getString("EndItem", "debug")).getDefaultItem(null, 1);
                damage = new GameDamage(damage.type, (damage.damage + headItem.getGndData().getFloat("BaseDamage", 0.0f) + bodyItem.getGndData().getFloat("BaseDamage", 0.0f) + endItem.getGndData().getFloat("BaseDamage", 0.0f)) * headItem.getGndData().getFloat("DamageMod", 1.0f) * bodyItem.getGndData().getFloat("DamageMod", 1.0f) * endItem.getGndData().getFloat("DamageMod", 1.0f), (damage.armorPen + headItem.getGndData().getFloat("BaseArmorPen", 0.0f) + bodyItem.getGndData().getFloat("BaseArmorPen", 0.0f) + endItem.getGndData().getFloat("BaseArmorPen", 0.0f)) * headItem.getGndData().getFloat("ArmorPenMod", 1.0f) * bodyItem.getGndData().getFloat("ArmorPenMod", 1.0f) * endItem.getGndData().getFloat("ArmorPenMod", 1.0f), damage.baseCritChance, damage.playerDamageMultiplier, damage.finalDamageMultiplier);
                knockback = knockback + headItem.getGndData().getInt("KnockbackAdd", 0) + bodyItem.getGndData().getInt("KnockbackAdd", 0) + endItem.getGndData().getInt("KnockbackAdd", 0);
                velocity = velocity * headItem.getGndData().getFloat("VelocityMod", 1.0f) * bodyItem.getGndData().getFloat("VelocityMod", 1.0f) * endItem.getGndData().getFloat("VelocityMod", 1.0f);
                range = range + headItem.getGndData().getInt("RangeAdd", 0) + bodyItem.getGndData().getInt("RangeAdd", 0) + endItem.getGndData().getInt("RangeAdd", 0);
                return new HandGunBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            return new HandGunBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
        }
        return new HandGunBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
    }

    public boolean overrideProjectile() {
        return true;
    }

    public String getTranslatedTypeName() {
        return Localization.translate((String)"item", (String)"bullet");
    }
}

