/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.forms.gunsmith;

import gunsmith.forms.gunsmith.GunsmithContainer;
import gunsmith.gunsmith;
import java.awt.Rectangle;
import java.util.Iterator;
import necesse.engine.GlobalData;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.client.Client;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.fairType.FairType;
import necesse.gfx.fairType.TypeParsers;
import necesse.gfx.fairType.parsers.TypeParser;
import necesse.gfx.forms.ContainerComponent;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormFairTypeLabel;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabelEdit;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.containerSlot.FormContainerSlot;
import necesse.gfx.forms.components.lists.FormRecipeList;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.position.FormPositionContainer;
import necesse.gfx.forms.presets.containerComponent.ContainerFormSwitcher;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.ui.ButtonColor;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventoryUpdateListener;
import necesse.inventory.container.Container;
import necesse.inventory.item.upgradeUtils.UpgradedItem;

public class GunsmithContainerForm<T extends GunsmithContainer>
extends ContainerFormSwitcher<T> {
    public Form mainForm = (Form)this.addComponent((FormComponent)new Form(400, 120));
    public UpgradedItem lastUpgradedItem;
    private final int upgradeContentY;
    private FormContentBox upgradeContent;
    public FormLabelEdit label;
    public FormTextInput inputField;
    protected FormLocalTextButton upgradeButton;
    protected FormRecipeList recipeUpdateListener;
    protected InventoryUpdateListener inventoryUpdateListener;

    public GunsmithContainerForm(Client client, T container) {
        super(client, container);
        FormFlow flow = new FormFlow(5);
        this.mainForm.addComponent((FormComponent)((FormLocalLabel)flow.nextY((FormPositionContainer)new FormLocalLabel(((GunsmithContainer)((Object)container)).upgradeEntity.getObject().getLocalization(), new FontOptions(20), 0, this.mainForm.getWidth() / 2, 5), 5)));
        this.mainForm.addComponent((FormComponent)((FormLocalLabel)flow.nextY((FormPositionContainer)new FormLocalLabel("ui", "gunsmithInstructions", new FontOptions(16), 0, this.mainForm.getWidth() / 2, 4, this.mainForm.getWidth() - 10), 5)));
        int containerRow = flow.next(45);
        final GameTexture[] decalsTop = new GameTexture[]{gunsmith.icon_barrel, gunsmith.icon_pickaxe, gunsmith.icon_shovel};
        final GameTexture[] decalsMiddle = new GameTexture[]{gunsmith.icon_body, gunsmith.icon_brace, gunsmith.icon_brace};
        final GameTexture[] decalsBottom = new GameTexture[]{gunsmith.icon_stock, gunsmith.icon_shaft, gunsmith.icon_shaft};
        this.mainForm.addComponent((FormComponent)new FormContainerSlot(client, (Container)container, ((GunsmithContainer)((Object)container)).BARREL_SLOT, this.mainForm.getWidth() / 2 - 90, containerRow){

            public void drawDecal(PlayerMob perspective) {
                int decal = (int)(System.currentTimeMillis() % (long)(decalsTop.length * 1000)) / 1000;
                this.setDecal(decalsTop[decal]);
                super.drawDecal(perspective);
            }
        });
        this.mainForm.addComponent((FormComponent)new FormContainerSlot(client, (Container)container, ((GunsmithContainer)((Object)container)).BODY_SLOT, this.mainForm.getWidth() / 2 - 10, containerRow){

            public void drawDecal(PlayerMob perspective) {
                int decal = (int)(System.currentTimeMillis() % (long)(decalsMiddle.length * 1000)) / 1000;
                this.setDecal(decalsMiddle[decal]);
                super.drawDecal(perspective);
            }
        });
        this.mainForm.addComponent((FormComponent)new FormContainerSlot(client, (Container)container, ((GunsmithContainer)((Object)container)).STOCK_SLOT, this.mainForm.getWidth() / 2 + 70, containerRow){

            public void drawDecal(PlayerMob perspective) {
                int decal = (int)(System.currentTimeMillis() % (long)(decalsBottom.length * 1000)) / 1000;
                this.setDecal(decalsBottom[decal]);
                super.drawDecal(perspective);
            }
        });
        this.upgradeContentY = flow.next();
        int upgradeButtonMaxWidth = 300;
        int upgradeButtonWidth = Math.min(this.mainForm.getWidth() - 8, upgradeButtonMaxWidth);
        this.upgradeButton = (FormLocalTextButton)this.mainForm.addComponent((FormComponent)new FormLocalTextButton("ui", "wepCraftButton", this.mainForm.getWidth() / 2 - upgradeButtonWidth / 2, flow.next(28), upgradeButtonWidth, FormInputSize.SIZE_24, ButtonColor.BASE){});
        this.upgradeButton.onClicked(e -> container.craftButton.runAndSend());
        this.lastUpgradedItem = ((GunsmithContainer)((Object)container)).getUpgradedItem();
        this.updateFormContent();
        this.makeCurrent((FormComponent)this.mainForm);
    }

    protected void init() {
        super.init();
        this.recipeUpdateListener = new FormRecipeList(){

            public void updateCraftable() {
                GunsmithContainerForm.this.updateFormContent();
            }

            public void updateRecipes() {
            }
        };
        GlobalData.craftingLists.add(this.recipeUpdateListener);
        this.inventoryUpdateListener = ((GunsmithContainer)this.container).upgradeEntity.inventory.addSlotUpdateListener(new InventoryUpdateListener(){

            public void onSlotUpdate(int slot) {
                GunsmithContainerForm.this.lastUpgradedItem = ((GunsmithContainer)GunsmithContainerForm.this.container).getUpgradedItem();
                GunsmithContainerForm.this.updateFormContent();
            }

            public boolean isDisposed() {
                return GunsmithContainerForm.this.isDisposed();
            }
        });
    }

    public static TypeParser<?>[] getParsers(FontOptions fontOptions) {
        return new TypeParser[]{TypeParsers.GAME_COLOR, TypeParsers.REMOVE_URL, TypeParsers.URL_OPEN, TypeParsers.ItemIcon((int)fontOptions.getSize()), TypeParsers.MobIcon((int)fontOptions.getSize()), TypeParsers.InputIcon((FontOptions)fontOptions)};
    }

    private void runEditUpdate() {
        if (!this.label.isTyping()) {
            // empty if block
        }
        ((GunsmithContainer)this.container).NAME = this.label.getText();
    }

    public void updateFormContent() {
        if (this.upgradeContent != null) {
            this.mainForm.removeComponent((FormComponent)this.upgradeContent);
        }
        FormFlow flow = new FormFlow(this.upgradeContentY);
        this.upgradeContent = (FormContentBox)this.mainForm.addComponent((FormComponent)new FormContentBox(0, flow.next(), this.mainForm.getWidth(), 300));
        FormFlow upgradeFlow = new FormFlow();
        Object canCraft = null;
        if (((GunsmithContainer)this.container).sameType()) {
            this.upgradeContent.addComponent((FormComponent)((FormLocalLabel)upgradeFlow.nextY((FormPositionContainer)new FormLocalLabel("ui", "benchOutput", new FontOptions(20), 0, this.upgradeContent.getWidth() / 2, 0, this.upgradeContent.getWidth() - 10), 2)));
            InventoryItem result = ((GunsmithContainer)this.container).getCraftedItem();
            StringBuilder displayString = new StringBuilder("[item=" + result.item.getStringID() + "]{");
            Iterator GNDKeys = result.getGndData().getDirtyKeys().iterator();
            while (GNDKeys.hasNext()) {
                Integer keyValue = (Integer)GNDKeys.next();
                displayString.append(keyValue).append("={");
                displayString.append("gndType=").append(result.getGndData().getItem(keyValue.intValue()).getStringID()).append(",");
                displayString.append("value=").append(result.getGndData().getItem(keyValue.intValue())).append("}");
                if (!GNDKeys.hasNext()) continue;
                displayString.append(",");
            }
            displayString.append("}");
            String display = displayString.toString();
            FormFairTypeLabel label = new FormFairTypeLabel(display, this.upgradeContent.getMinContentWidth() / 2, 10);
            label.setMaxWidth(this.upgradeContent.getMinContentWidth() - 10);
            label.setTextAlign(FairType.TextAlign.CENTER);
            label.setParsers(new TypeParser[]{TypeParsers.ItemIcon((int)30)});
            this.upgradeContent.addComponent((FormComponent)((FormFairTypeLabel)upgradeFlow.nextY((FormPositionContainer)label, 2)));
        }
        if (this.upgradeContent.getHeight() > upgradeFlow.next()) {
            this.upgradeContent.setHeight(upgradeFlow.next());
        }
        this.upgradeContent.setContentBox(new Rectangle(this.upgradeContent.getWidth(), upgradeFlow.next()));
        flow.next(this.upgradeContent.getHeight());
        flow.nextY((FormPositionContainer)this.upgradeButton, 4);
        if (!(((GunsmithContainer)this.container).upgradeEntity.inventory.isSlotClear(0) || ((GunsmithContainer)this.container).upgradeEntity.inventory.isSlotClear(1) || ((GunsmithContainer)this.container).upgradeEntity.inventory.isSlotClear(2))) {
            if (((GunsmithContainer)this.container).sameType()) {
                this.upgradeButton.setActive(true);
            }
        } else {
            this.upgradeButton.setActive(false);
        }
        this.mainForm.setHeight(flow.next());
        this.onWindowResized(WindowManager.getWindow());
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        super.draw(tickManager, perspective, renderBox);
    }

    public void onWindowResized(GameWindow window) {
        super.onWindowResized(window);
        ContainerComponent.setPosFocus((Form)this.mainForm);
    }

    public boolean shouldOpenInventory() {
        return true;
    }

    public void dispose() {
        super.dispose();
        Settings.hasCraftingListExpanded.cleanListeners();
        Settings.hasCraftingFilterExpanded.cleanListeners();
        if (this.recipeUpdateListener != null) {
            GlobalData.craftingLists.remove(this.recipeUpdateListener);
        }
        if (this.inventoryUpdateListener != null) {
            this.inventoryUpdateListener.dispose();
        }
    }
}

