/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.forms.bonusparts;

import gunsmith.forms.bonusparts.BonusPartContainer;
import gunsmith.gunsmith;
import java.awt.Color;
import java.awt.Rectangle;
import necesse.engine.GlobalData;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.network.client.Client;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.fairType.TypeParsers;
import necesse.gfx.fairType.parsers.TypeParser;
import necesse.gfx.forms.ContainerComponent;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabelEdit;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.containerSlot.FormContainerSlot;
import necesse.gfx.forms.components.lists.FormRecipeList;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.position.FormPositionContainer;
import necesse.gfx.forms.presets.containerComponent.ContainerFormSwitcher;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.ui.ButtonColor;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventoryUpdateListener;
import necesse.inventory.container.Container;
import necesse.inventory.item.upgradeUtils.UpgradedItem;

public class BonusPartContainerForm<T extends BonusPartContainer>
extends ContainerFormSwitcher<T> {
    public Form mainForm = (Form)this.addComponent((FormComponent)new Form(400, 120));
    public UpgradedItem lastUpgradedItem;
    private final int upgradeContentY;
    private FormContentBox upgradeContent;
    public FormLabelEdit label;
    public FormLocalLabel instructionsStart;
    public FormLocalLabel instructionsSame;
    public FormLocalLabel instructionsDifferent;
    public FormLocalLabel instructionsTotals;
    public FormTextInput inputField;
    protected FormLocalTextButton upgradeButton;
    protected FormRecipeList recipeUpdateListener;
    protected InventoryUpdateListener inventoryUpdateListener;

    public BonusPartContainerForm(Client client, T container) {
        super(client, container);
        FormFlow flow = new FormFlow(5);
        this.mainForm.addComponent((FormComponent)((FormLocalLabel)flow.nextY((FormPositionContainer)new FormLocalLabel(((BonusPartContainer)((Object)container)).upgradeEntity.getObject().getLocalization(), new FontOptions(20), 0, this.mainForm.getWidth() / 2, 5), 5)));
        this.instructionsStart = (FormLocalLabel)this.mainForm.addComponent((FormComponent)((FormLocalLabel)flow.nextY((FormPositionContainer)new FormLocalLabel("ui", "bonusPartsInstructionsStart", new FontOptions(16).alpha(10), 0, this.mainForm.getWidth() / 2, 4, this.mainForm.getWidth() - 10), 5)));
        this.instructionsDifferent = (FormLocalLabel)this.mainForm.addComponent((FormComponent)((FormLocalLabel)flow.nextY((FormPositionContainer)new FormLocalLabel("ui", "bonusPartsInstructionsDifferent", new FontOptions(16), 0, this.mainForm.getWidth() / 2, 4, this.mainForm.getWidth() - 10), 5)));
        this.instructionsSame = (FormLocalLabel)this.mainForm.addComponent((FormComponent)((FormLocalLabel)flow.sameY((FormPositionContainer)new FormLocalLabel("ui", "bonusPartsInstructionsSame", new FontOptions(16).alpha(10), 0, this.mainForm.getWidth() / 2, 4, this.mainForm.getWidth() - 10), 5)));
        this.instructionsTotals = (FormLocalLabel)this.mainForm.addComponent((FormComponent)((FormLocalLabel)flow.nextY((FormPositionContainer)new FormLocalLabel("ui", "bonusPartsInstructionsTotals", new FontOptions(16), 0, this.mainForm.getWidth() / 2, 4, this.mainForm.getWidth() - 10), 5)));
        int containerRow = flow.next(45);
        final GameTexture[] decalsTop = new GameTexture[]{gunsmith.icon_barrel, gunsmith.icon_pickaxe, gunsmith.icon_shovel};
        final GameTexture[] decalsMiddle = new GameTexture[]{gunsmith.icon_body, gunsmith.icon_brace, gunsmith.icon_brace};
        final GameTexture[] decalsBottom = new GameTexture[]{gunsmith.icon_stock, gunsmith.icon_shaft, gunsmith.icon_shaft};
        this.mainForm.addComponent((FormComponent)new FormContainerSlot(client, (Container)container, ((BonusPartContainer)((Object)container)).BARREL_SLOT, this.mainForm.getWidth() / 2 - 90, containerRow){

            public void drawDecal(PlayerMob perspective) {
                int decal = (int)(System.currentTimeMillis() % (long)(decalsTop.length * 1000)) / 1000;
                this.setDecal(decalsTop[decal]);
                super.drawDecal(perspective);
            }
        });
        this.mainForm.addComponent((FormComponent)new FormContainerSlot(client, (Container)container, ((BonusPartContainer)((Object)container)).BODY_SLOT, this.mainForm.getWidth() / 2 - 10, containerRow){

            public void drawDecal(PlayerMob perspective) {
                int decal = (int)(System.currentTimeMillis() % (long)(decalsMiddle.length * 1000)) / 1000;
                this.setDecal(decalsMiddle[decal]);
                super.drawDecal(perspective);
            }
        });
        this.mainForm.addComponent((FormComponent)new FormContainerSlot(client, (Container)container, ((BonusPartContainer)((Object)container)).STOCK_SLOT, this.mainForm.getWidth() / 2 + 70, containerRow){

            public void drawDecal(PlayerMob perspective) {
                int decal = (int)(System.currentTimeMillis() % (long)(decalsBottom.length * 1000)) / 1000;
                this.setDecal(decalsBottom[decal]);
                super.drawDecal(perspective);
            }
        });
        this.upgradeContentY = flow.next();
        int upgradeButtonMaxWidth = 300;
        int upgradeButtonWidth = Math.min(this.mainForm.getWidth() - 8, upgradeButtonMaxWidth);
        this.upgradeButton = (FormLocalTextButton)this.mainForm.addComponent((FormComponent)new FormLocalTextButton("ui", "bonusMergeButton", this.mainForm.getWidth() / 2 - upgradeButtonWidth / 2, flow.next(28), upgradeButtonWidth, FormInputSize.SIZE_24, ButtonColor.BASE){});
        this.upgradeButton.onClicked(e -> container.craftButton.runAndSend());
        this.lastUpgradedItem = ((BonusPartContainer)((Object)container)).getUpgradedItem();
        this.updateFormContent();
        this.makeCurrent((FormComponent)this.mainForm);
    }

    protected void init() {
        super.init();
        this.recipeUpdateListener = new FormRecipeList(){

            public void updateCraftable() {
                BonusPartContainerForm.this.updateFormContent();
            }

            public void updateRecipes() {
            }
        };
        GlobalData.craftingLists.add(this.recipeUpdateListener);
        this.inventoryUpdateListener = ((BonusPartContainer)this.container).upgradeEntity.inventory.addSlotUpdateListener(new InventoryUpdateListener(){

            public void onSlotUpdate(int slot) {
                BonusPartContainerForm.this.lastUpgradedItem = ((BonusPartContainer)BonusPartContainerForm.this.container).getUpgradedItem();
                BonusPartContainerForm.this.updateFormContent();
            }

            public boolean isDisposed() {
                return BonusPartContainerForm.this.isDisposed();
            }
        });
    }

    public static TypeParser<?>[] getParsers(FontOptions fontOptions) {
        return new TypeParser[]{TypeParsers.GAME_COLOR, TypeParsers.REMOVE_URL, TypeParsers.URL_OPEN, TypeParsers.ItemIcon((int)fontOptions.getSize()), TypeParsers.MobIcon((int)fontOptions.getSize()), TypeParsers.InputIcon((FontOptions)fontOptions)};
    }

    private void runEditUpdate() {
        if (!this.label.isTyping()) {
            // empty if block
        }
        ((BonusPartContainer)this.container).NAME = this.label.getText();
    }

    public void updateFormContent() {
        if (this.upgradeContent != null) {
            this.mainForm.removeComponent((FormComponent)this.upgradeContent);
        }
        InventoryItem itemSlot1 = ((BonusPartContainer)this.container).upgradeEntity.inventory.getItem(0);
        InventoryItem itemSlot2 = ((BonusPartContainer)this.container).upgradeEntity.inventory.getItem(1);
        InventoryItem itemSlot3 = ((BonusPartContainer)this.container).upgradeEntity.inventory.getItem(2);
        if (((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(0) && ((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(1) && ((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(2)) {
            this.instructionsSame.setText("");
            this.instructionsDifferent.setText("");
            this.instructionsTotals.setText("");
            this.instructionsSame.setColor(Color.BLACK);
            this.instructionsDifferent.setColor(Color.BLACK);
            this.instructionsTotals.setColor(Color.BLACK);
        } else if (!((((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(0) || itemSlot1.getGndData().getString("BarrelBonus").isEmpty() && itemSlot1.getGndData().getString("BodyBonus").isEmpty() && itemSlot1.getGndData().getString("StockBonus").isEmpty()) && (((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(1) || itemSlot2.getGndData().getString("BarrelBonus").isEmpty() && itemSlot2.getGndData().getString("BodyBonus").isEmpty() && itemSlot2.getGndData().getString("StockBonus").isEmpty()) && (((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(2) || itemSlot3.getGndData().getString("BarrelBonus").isEmpty() && itemSlot3.getGndData().getString("BodyBonus").isEmpty() && itemSlot3.getGndData().getString("StockBonus").isEmpty()))) {
            this.instructionsSame.setColor(Color.DARK_GRAY);
            this.instructionsSame.setText("");
            this.instructionsDifferent.setText(Localization.translate((String)"ui", (String)"bonusPartsInstructionsDifferent"), 400);
            this.instructionsTotals.setText(Localization.translate((String)"ui", (String)"bonusPartsInstructionsTotals"), 400);
            this.instructionsDifferent.setColor(Color.BLACK);
            this.instructionsTotals.setColor(Color.BLACK);
        } else {
            this.instructionsSame.setColor(Color.BLACK);
            this.instructionsSame.setText(Localization.translate((String)"ui", (String)"bonusPartsInstructionsSame"), 400);
            this.instructionsDifferent.setText("");
            this.instructionsTotals.setText("");
            this.instructionsDifferent.setColor(Color.DARK_GRAY);
            this.instructionsTotals.setColor(Color.DARK_GRAY);
        }
        FormFlow flow = new FormFlow(this.upgradeContentY);
        this.upgradeContent = (FormContentBox)this.mainForm.addComponent((FormComponent)new FormContentBox(0, flow.next(), this.mainForm.getWidth(), 300));
        FormFlow upgradeFlow = new FormFlow();
        Object canCraft = null;
        if (this.upgradeContent.getHeight() > upgradeFlow.next()) {
            this.upgradeContent.setHeight(upgradeFlow.next());
        }
        this.upgradeContent.setContentBox(new Rectangle(this.upgradeContent.getWidth(), upgradeFlow.next()));
        flow.next(this.upgradeContent.getHeight());
        flow.nextY((FormPositionContainer)this.upgradeButton, 4);
        if (!(((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(0) || ((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(1) || ((BonusPartContainer)this.container).upgradeEntity.inventory.isSlotClear(2))) {
            if (((BonusPartContainer)this.container).sameItem() || ((BonusPartContainer)this.container).allHaveBonus()) {
                this.upgradeButton.setActive(true);
            }
        } else {
            this.upgradeButton.setActive(false);
        }
        this.mainForm.setHeight(flow.next());
        this.onWindowResized(WindowManager.getWindow());
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        super.draw(tickManager, perspective, renderBox);
    }

    public void onWindowResized(GameWindow window) {
        super.onWindowResized(window);
        ContainerComponent.setPosFocus((Form)this.mainForm);
    }

    public boolean shouldOpenInventory() {
        return true;
    }

    public void dispose() {
        super.dispose();
        Settings.hasCraftingListExpanded.cleanListeners();
        Settings.hasCraftingFilterExpanded.cleanListeners();
        if (this.recipeUpdateListener != null) {
            GlobalData.craftingLists.remove(this.recipeUpdateListener);
        }
        if (this.inventoryUpdateListener != null) {
            this.inventoryUpdateListener.dispose();
        }
    }
}

