/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.forms.bonusparts;

import gunsmith.forms.bonusparts.BonusPartItemContainerSlot;
import gunsmith.objects.bonuspartsbench.BonusPartStationObjectEntity;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.LinkedHashSet;
import necesse.engine.GameLog;
import necesse.engine.GameTileRange;
import necesse.engine.GlobalData;
import necesse.engine.Settings;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.util.GameRandom;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.container.Container;
import necesse.inventory.container.customAction.ContainerCustomAction;
import necesse.inventory.container.customAction.EmptyCustomAction;
import necesse.inventory.container.object.CraftingStationContainer;
import necesse.inventory.container.slots.ContainerSlot;
import necesse.inventory.item.upgradeUtils.UpgradableItem;
import necesse.inventory.item.upgradeUtils.UpgradedItem;
import necesse.level.maps.Level;
import necesse.level.maps.multiTile.MultiTile;

public class BonusPartContainer
extends Container {
    public final int BARREL_SLOT;
    public final int BODY_SLOT;
    public final int STOCK_SLOT;
    public String NAME;
    public static int MAX_NAME_LENGTH = 40;
    public final BonusPartStationObjectEntity upgradeEntity;
    public final EmptyCustomAction craftButton;
    public final GameTileRange ingredientRange;
    private LinkedHashSet<Inventory> nearbyInventories = new LinkedHashSet();

    public BonusPartContainer(NetworkClient client, int uniqueSeed, BonusPartStationObjectEntity upgradeEntity, PacketReader reader) {
        super(client, uniqueSeed);
        this.upgradeEntity = upgradeEntity;
        this.BARREL_SLOT = this.addSlot(new BonusPartItemContainerSlot(upgradeEntity.inventory, 0));
        this.addInventoryQuickTransfer(this.BARREL_SLOT, this.BARREL_SLOT);
        this.BODY_SLOT = this.addSlot(new BonusPartItemContainerSlot(upgradeEntity.inventory, 1));
        this.addInventoryQuickTransfer(this.BODY_SLOT, this.BODY_SLOT);
        this.STOCK_SLOT = this.addSlot(new BonusPartItemContainerSlot(upgradeEntity.inventory, 2));
        this.NAME = "";
        this.addInventoryQuickTransfer(this.STOCK_SLOT, this.STOCK_SLOT);
        MultiTile multiTile = upgradeEntity.getLevelObject().getMultiTile();
        Rectangle tileRectangle = multiTile.getTileRectangle(0, 0);
        this.ingredientRange = new GameTileRange(CraftingStationContainer.nearbyCraftTileRange, tileRectangle);
        this.nearbyInventories.addAll(this.craftInventories);
        this.craftButton = (EmptyCustomAction)this.registerAction((ContainerCustomAction)new EmptyCustomAction(){

            protected void run() {
                if (BonusPartContainer.this.sameItem() || BonusPartContainer.this.allHaveBonus()) {
                    InventoryItem result = BonusPartContainer.this.getCraftedItem();
                    if (BonusPartContainer.this.getSlot(BonusPartContainer.this.CLIENT_DRAGGING_SLOT).isClear()) {
                        BonusPartContainer.this.getSlot(BonusPartContainer.this.CLIENT_DRAGGING_SLOT).setItem(result);
                        BonusPartContainer.this.getSlot(BonusPartContainer.this.BARREL_SLOT).setItem((InventoryItem)null);
                        BonusPartContainer.this.getSlot(BonusPartContainer.this.BODY_SLOT).setItem((InventoryItem)null);
                        BonusPartContainer.this.getSlot(BonusPartContainer.this.STOCK_SLOT).setItem((InventoryItem)null);
                    } else {
                        BonusPartContainer.this.getSlot(BonusPartContainer.this.BODY_SLOT).setItem(result);
                        BonusPartContainer.this.getSlot(BonusPartContainer.this.BARREL_SLOT).setItem((InventoryItem)null);
                        BonusPartContainer.this.getSlot(BonusPartContainer.this.STOCK_SLOT).setItem((InventoryItem)null);
                    }
                }
            }
        });
    }

    public boolean sameItem() {
        if (this.getSlot(this.BARREL_SLOT).isClear() || this.getSlot(this.BODY_SLOT).isClear() || this.getSlot(this.STOCK_SLOT).isClear()) {
            return false;
        }
        InventoryItem item1 = this.getSlot(this.BARREL_SLOT).getItem();
        InventoryItem item2 = this.getSlot(this.BODY_SLOT).getItem();
        InventoryItem item3 = this.getSlot(this.STOCK_SLOT).getItem();
        return item1.item == item2.item && item1.item == item3.item;
    }

    public boolean allHaveBonus() {
        if (this.getSlot(this.BARREL_SLOT).isClear() || this.getSlot(this.BODY_SLOT).isClear() || this.getSlot(this.STOCK_SLOT).isClear()) {
            return false;
        }
        InventoryItem item1 = this.getSlot(this.BARREL_SLOT).getItem();
        InventoryItem item2 = this.getSlot(this.BODY_SLOT).getItem();
        InventoryItem item3 = this.getSlot(this.STOCK_SLOT).getItem();
        boolean slot1Bonus = item1.getGndData().hasKey("BarrelBonus") || item1.getGndData().hasKey("BodyBonus") || item1.getGndData().hasKey("StockBonus");
        boolean slot2Bonus = item2.getGndData().hasKey("BarrelBonus") || item2.getGndData().hasKey("BodyBonus") || item2.getGndData().hasKey("StockBonus");
        boolean slot3Bonus = item3.getGndData().hasKey("BarrelBonus") || item3.getGndData().hasKey("BodyBonus") || item3.getGndData().hasKey("StockBonus");
        return slot1Bonus && slot2Bonus && slot3Bonus;
    }

    private boolean useNearbyInventories() {
        return this.client.isServer() ? this.client.craftingUsesNearbyInventories : (Boolean)Settings.craftingUseNearby.get();
    }

    public Collection<Inventory> getCraftInventories() {
        return this.useNearbyInventories() ? this.nearbyInventories : super.getCraftInventories();
    }

    public UpgradedItem getUpgradedItem() {
        ContainerSlot slot = this.getSlot(this.BARREL_SLOT);
        if (!slot.isClear()) {
            InventoryItem slotItem = slot.getItem();
            if (slotItem.item instanceof UpgradableItem && ((UpgradableItem)slotItem.item).getCanBeUpgradedError(slotItem) == null) {
                return ((UpgradableItem)slotItem.item).getUpgradedItem(slotItem);
            }
        }
        return null;
    }

    public InventoryItem getCraftedItem() {
        if (this.allHaveBonus()) {
            int randomSlot = GameRandom.globalRandom.getIntBetween(0, 2);
            InventoryItem result = randomSlot == 0 ? new InventoryItem(this.getSlot((int)this.BARREL_SLOT).getItem().item, 1) : (randomSlot == 1 ? new InventoryItem(this.getSlot((int)this.BODY_SLOT).getItem().item, 1) : new InventoryItem(this.getSlot((int)this.STOCK_SLOT).getItem().item, 1));
            int randomBonus = GameRandom.globalRandom.getIntBetween(0, 2);
            float randomBonusValue = 0.0f;
            InventoryItem resultBonus = randomBonus == 0 ? this.getSlot(this.BARREL_SLOT).getItem() : (randomBonus == 1 ? this.getSlot(this.BODY_SLOT).getItem() : this.getSlot(this.STOCK_SLOT).getItem());
            String bonusType = "";
            if (resultBonus.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Barrel")) {
                bonusType = resultBonus.getGndData().getString("BarrelBonus");
                randomBonusValue = resultBonus.getGndData().getFloat("BarrelBonusValue");
            } else if (resultBonus.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Body")) {
                bonusType = resultBonus.getGndData().getString("BodyBonus");
                randomBonusValue = resultBonus.getGndData().getFloat("BodyBonusValue");
            } else if (resultBonus.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Stock")) {
                GameLog.warn.println("wack");
                bonusType = resultBonus.getGndData().getString("StockBonus");
                randomBonusValue = resultBonus.getGndData().getFloat("StockBonusValue");
            }
            if (result.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Barrel")) {
                result.getGndData().setString("BarrelBonus", bonusType);
            } else if (result.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Body")) {
                result.getGndData().setString("BodyBonus", bonusType);
            } else if (result.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Stock")) {
                GameLog.warn.println("wack2");
                result.getGndData().setString("StockBonus", bonusType);
            }
            float low = result.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + bonusType);
            if (this.getSlot(this.BARREL_SLOT).getItem().getGndData().getString("BarrelBonus").equalsIgnoreCase(bonusType)) {
                if (this.getSlot(this.BARREL_SLOT).getItem().getGndData().getFloat("BarrelBonusValue") > low) {
                    low = this.getSlot(this.BARREL_SLOT).getItem().getGndData().getFloat("BarrelBonusValue");
                }
            } else if (this.getSlot(this.BARREL_SLOT).getItem().getGndData().getString("BodyBonus").equalsIgnoreCase(bonusType)) {
                if (this.getSlot(this.BARREL_SLOT).getItem().getGndData().getFloat("BodyBonusValue") > low) {
                    low = this.getSlot(this.BARREL_SLOT).getItem().getGndData().getFloat("BodyBonusValue");
                }
            } else if (this.getSlot(this.BARREL_SLOT).getItem().getGndData().getString("StockBonus").equalsIgnoreCase(bonusType) && this.getSlot(this.BARREL_SLOT).getItem().getGndData().getFloat("StockBonusValue") > low) {
                low = this.getSlot(this.BARREL_SLOT).getItem().getGndData().getFloat("StockBonusValue");
            }
            if (this.getSlot(this.BODY_SLOT).getItem().getGndData().getString("BarrelBonus").equalsIgnoreCase(bonusType)) {
                if (this.getSlot(this.BODY_SLOT).getItem().getGndData().getFloat("BarrelBonusValue") > low) {
                    low = this.getSlot(this.BODY_SLOT).getItem().getGndData().getFloat("BarrelBonusValue");
                }
            } else if (this.getSlot(this.BODY_SLOT).getItem().getGndData().getString("BodyBonus").equalsIgnoreCase(bonusType)) {
                if (this.getSlot(this.BODY_SLOT).getItem().getGndData().getFloat("BodyBonusValue") > low) {
                    low = this.getSlot(this.BODY_SLOT).getItem().getGndData().getFloat("BodyBonusValue");
                }
            } else if (this.getSlot(this.BODY_SLOT).getItem().getGndData().getString("StockBonus").equalsIgnoreCase(bonusType) && this.getSlot(this.BODY_SLOT).getItem().getGndData().getFloat("StockBonusValue") > low) {
                low = this.getSlot(this.BODY_SLOT).getItem().getGndData().getFloat("StockBonusValue");
            }
            if (this.getSlot(this.STOCK_SLOT).getItem().getGndData().getString("BarrelBonus").equalsIgnoreCase(bonusType)) {
                if (this.getSlot(this.STOCK_SLOT).getItem().getGndData().getFloat("BarrelBonusValue") > low) {
                    low = this.getSlot(this.STOCK_SLOT).getItem().getGndData().getFloat("BarrelBonusValue");
                }
            } else if (this.getSlot(this.STOCK_SLOT).getItem().getGndData().getString("BodyBonus").equalsIgnoreCase(bonusType)) {
                if (this.getSlot(this.STOCK_SLOT).getItem().getGndData().getFloat("BodyBonusValue") > low) {
                    low = this.getSlot(this.STOCK_SLOT).getItem().getGndData().getFloat("BodyBonusValue");
                }
            } else if (this.getSlot(this.STOCK_SLOT).getItem().getGndData().getString("StockBonus").equalsIgnoreCase(bonusType) && this.getSlot(this.STOCK_SLOT).getItem().getGndData().getFloat("StockBonusValue") > low) {
                low = this.getSlot(this.STOCK_SLOT).getItem().getGndData().getFloat("StockBonusValue");
            }
            float high = result.item.getDefaultItem(null, 1).getGndData().getFloat("High" + bonusType);
            float newValue = low * GameRandom.globalRandom.getFloatBetween(1.35f, 1.7f);
            if (newValue > high) {
                newValue = high;
            }
            newValue = Math.round((double)Math.round((double)newValue * 100.0) / 100.0);
            if (result.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Barrel")) {
                result.getGndData().setFloat("BarrelBonusValue", newValue);
            } else if (result.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Body")) {
                result.getGndData().setFloat("BodyBonusValue", newValue);
            } else if (result.item.getDefaultItem(null, 1).getGndData().getString("Part").equalsIgnoreCase("Stock")) {
                GameLog.warn.println("wack3");
                result.getGndData().setFloat("StockBonusValue", newValue);
            }
            GameLog.debug.println("Generated Item: " + result.getItemDisplayName());
            GameLog.debug.println("Generated Bonus: " + bonusType);
            GameLog.debug.println("Generated Bonus Value: " + newValue);
            return result;
        }
        if (this.sameItem() && !this.allHaveBonus()) {
            InventoryItem result = new InventoryItem(this.getSlot((int)this.BARREL_SLOT).getItem().item, 1);
            result.getGndData().setBoolean("BonusActivate", true);
            result.getGndData().setBoolean("isCrafted", true);
            return result;
        }
        return null;
    }

    public void tick() {
        super.tick();
        if (this.client.isClient() && ((Boolean)Settings.craftingUseNearby.get()).booleanValue()) {
            boolean updateCraftable = false;
            for (Inventory inv : this.nearbyInventories) {
                if (inv.isDirty()) {
                    updateCraftable = true;
                }
                inv.clean();
            }
            if (updateCraftable) {
                GlobalData.updateCraftable();
            }
        }
    }

    public boolean isValid(ServerClient client) {
        if (!super.isValid(client)) {
            return false;
        }
        return !this.upgradeEntity.removed();
    }

    public static void openAndSendContainer(int containerID, ServerClient client, Level level, int tileX, int tileY, Packet extraContent) {
        if (!level.isServer()) {
            throw new IllegalStateException("Level must be a server level");
        }
        Packet packet = new Packet();
        PacketWriter writer = new PacketWriter(packet);
        if (extraContent != null) {
            writer.putNextContentPacket(extraContent);
        }
        PacketOpenContainer p = PacketOpenContainer.LevelObject((int)containerID, (int)tileX, (int)tileY, (Packet)packet);
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)p);
    }

    public static void openAndSendContainer(int containerID, ServerClient client, Level level, int tileX, int tileY) {
        BonusPartContainer.openAndSendContainer(containerID, client, level, tileX, tileY, null);
    }
}

