/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.events;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LineHitbox;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobAbilityLevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.DeathMessageTable;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.particle.Particle;
import necesse.entity.trails.LightningTrail;
import necesse.entity.trails.Trail;
import necesse.entity.trails.TrailVector;
import necesse.level.maps.LevelObjectHit;

public class JenWandBlastEvent
extends MobAbilityLevelEvent
implements Attacker {
    private static final int totalPoints = 12;
    private static final int distance = 70;
    private static final float distanceMod = 7.8f;
    private static final int ticksToComplete = 2;
    private int knockback;
    private boolean hit;
    private int startX;
    private int startY;
    private int targetX;
    private int targetY;
    private float xDir;
    private float yDir;
    private float resilienceGain;
    private int seed;
    private int tickCounter;
    private int pointCounter;
    private ArrayList<Point2D.Float> points;
    private ArrayList<Integer> hits;
    private LightningTrail trail;
    private float endX;
    private float endY;
    private float endX2;
    private float endY2;
    float closest;
    public Mob source;

    public JenWandBlastEvent() {
    }

    public JenWandBlastEvent(Mob owner, int knockback, float resilienceGain, int startX, int startY, int targetX, int targetY, int seed, Mob mob) {
        super(owner, new GameRandom((long)seed));
        this.startX = startX;
        this.startY = startY;
        this.targetX = targetX;
        this.targetY = targetY;
        this.resilienceGain = resilienceGain;
        this.seed = seed;
        this.source = mob;
        this.knockback = knockback;
        this.hit = false;
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.startX = reader.getNextInt();
        this.startY = reader.getNextInt();
        this.targetX = reader.getNextInt();
        this.targetY = reader.getNextInt();
        this.seed = reader.getNextInt();
        this.tickCounter = reader.getNextShortUnsigned();
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.startX);
        writer.putNextInt(this.startY);
        writer.putNextInt(this.targetX);
        writer.putNextInt(this.targetY);
        writer.putNextInt(this.seed);
        writer.putNextShortUnsigned(this.tickCounter);
    }

    public void init() {
        super.init();
        float l = (float)new Point(this.startX, this.startY).distance(this.targetX, this.targetY);
        this.xDir = (float)(this.targetX - this.startX) / l;
        this.yDir = (float)(this.targetY - this.startY) / l;
        this.points = this.generatePoints();
        this.trail = new LightningTrail(new TrailVector((float)this.startX, (float)this.startY, this.xDir, this.yDir, 42.5f, 15.0f), this.level, new Color(12, 195, 227));
        this.trail.addNewPoint(new TrailVector(this.points.get(0), this.xDir, this.yDir, this.trail.thickness, 18.0f));
        if (this.isClient()) {
            this.level.entityManager.addTrail((Trail)this.trail);
        }
        this.hits = new ArrayList();
    }

    public void clientTick() {
        if (!this.isOver()) {
            ++this.tickCounter;
            int expectedCounter = this.tickCounter * 12 / 2;
            while (this.pointCounter < expectedCounter) {
                int j;
                if (this.hit) {
                    this.over();
                    break;
                }
                ++this.pointCounter;
                if (this.pointCounter >= 12) {
                    this.over();
                    break;
                }
                Point2D.Float point = this.points.get(this.pointCounter);
                this.trail.addNewPoint(new TrailVector(point, this.xDir, this.yDir, this.trail.thickness, 18.0f));
                Point2D.Float lastPoint = this.points.get(this.pointCounter - 1);
                Point2D.Float midPoint = new Point2D.Float((point.x + lastPoint.x) / 2.0f, (point.y + lastPoint.y) / 2.0f);
                Point2D.Float norm = GameMath.normalize((float)(point.x - lastPoint.x), (float)(point.y - lastPoint.y));
                float distance = (float)point.distance(lastPoint);
                for (j = 0; j < 2; ++j) {
                    this.level.entityManager.addParticle(midPoint.x + norm.x * GameRandom.globalRandom.nextFloat() * distance, midPoint.y + norm.y * GameRandom.globalRandom.nextFloat() * distance, Particle.GType.COSMETIC).movesConstant((float)(GameRandom.globalRandom.nextGaussian() * 4.0), (float)(GameRandom.globalRandom.nextGaussian() * 4.0)).color(this.trail.col).height(18.0f);
                }
                if (this.pointCounter == 4) {
                    for (j = 0; j < 20; ++j) {
                        this.level.entityManager.addParticle(lastPoint.x + norm.x * 4.0f, lastPoint.y + norm.y * 4.0f, Particle.GType.COSMETIC).movesConstant((float)(GameRandom.globalRandom.nextGaussian() * 20.0), (float)(GameRandom.globalRandom.nextGaussian() * 20.0)).color(this.trail.col).height(18.0f).lifeTime(50);
                    }
                }
                Line2D.Double line = new Line2D.Double(lastPoint.getX(), lastPoint.getY(), point.getX(), point.getY());
                LineHitbox hitbox = new LineHitbox((Line2D)line, 20.0f);
                this.handleHits((Shape)hitbox, m -> m.canBeHit((Attacker)this) && !this.hasHit((Mob)m), null);
            }
        }
    }

    public void serverTick() {
        if (!this.isOver()) {
            ++this.tickCounter;
            int expectedCounter = this.tickCounter * 12 / 2;
            while (this.pointCounter < expectedCounter) {
                if (this.hit) {
                    this.over();
                    break;
                }
                ++this.pointCounter;
                if (this.pointCounter >= 12) {
                    this.over();
                    break;
                }
                Point2D p1 = this.points.get(this.pointCounter - 1);
                Point2D p2 = this.points.get(this.pointCounter);
                Line2D.Double line = new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
                LineHitbox hitbox = new LineHitbox((Line2D)line, 20.0f);
                this.handleHits((Shape)hitbox, m -> !this.hasHit((Mob)m), null);
            }
        }
    }

    private ArrayList<Point2D.Float> generatePoints() {
        ArrayList<Point2D.Float> out = new ArrayList<Point2D.Float>();
        GameRandom random = new GameRandom((long)this.seed);
        Point2D.Float perp = new Point2D.Float(-this.yDir, this.xDir);
        float lastDist = 0.0f;
        Point2D.Float lastPoint = new Point2D.Float(this.startX, this.startY);
        out.add(lastPoint);
        for (int i = 0; i < 12; ++i) {
            float fluctuation = (random.nextFloat() - 0.5f) * lastDist;
            lastDist = (random.nextFloat() + 0.5f) * 7.8f;
            lastPoint = new Point2D.Float(lastPoint.x + this.xDir * lastDist - perp.x * fluctuation, lastPoint.y + this.yDir * lastDist - perp.y * fluctuation);
            out.add(lastPoint);
        }
        return out;
    }

    public void clientHit(Mob target, Packet content) {
        super.clientHit(target, content);
        this.hit = true;
        this.hits.add(target.getUniqueID());
    }

    public void serverHit(Mob target, Packet content, boolean clientSubmitted) {
        super.serverHit(target, content, clientSubmitted);
        this.hits.add(target.getUniqueID());
    }

    public void hit(LevelObjectHit hit) {
        super.hit(hit);
        this.hit = true;
        hit.getLevelObject().attackThrough(new GameDamage(0.0f), (Attacker)this);
    }

    public DeathMessageTable getDeathMessages() {
        return this.getDeathMessages("lightning", 2);
    }

    public GameMessage getAttackerName() {
        return this.owner != null ? this.owner.getAttackerName() : new LocalMessage("deaths", "unknownatt");
    }

    public Mob getFirstAttackOwner() {
        return this.owner;
    }

    public boolean hasHit(Mob mob) {
        return this.hits.contains(mob.getUniqueID());
    }
}

