/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.events;

import gunsmith.packets.DeflectedProjectilePacket;
import gunsmith.packets.ReflectedProjectilePacket;
import gunsmith.projectiles.ReflectedProjectile;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import necesse.engine.GameLog;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.ClientClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.inventory.InventoryItem;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;

public class DeflectingToolItemMobAbilityEvent
extends ToolItemMobAbilityEvent {
    public int seed;
    public InventoryItem item;
    public Shape circle;

    public DeflectingToolItemMobAbilityEvent() {
    }

    public DeflectingToolItemMobAbilityEvent(AttackAnimMob mob, int seed, InventoryItem toolItem, int aimX, int aimY, int duration, int hitCooldown, HashMap<Integer, Long> mobHits) {
        super(mob, seed, toolItem, aimX, aimY, duration, hitCooldown, mobHits);
    }

    public DeflectingToolItemMobAbilityEvent(AttackAnimMob mob, int seed, InventoryItem toolItem, int aimX, int aimY, int duration, int hitCooldown) {
        this(mob, seed, toolItem, aimX, aimY, duration, hitCooldown, (HashMap<Integer, Long>)null);
    }

    public DeflectingToolItemMobAbilityEvent(AttackAnimMob mob, int seed, InventoryItem toolItem, int aimX, int aimY, int duration, int hitCooldown, Shape circle) {
        this(mob, seed, toolItem, aimX, aimY, duration, hitCooldown, (HashMap<Integer, Long>)null);
        this.circle = circle;
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
    }

    public void init() {
        super.init();
    }

    protected boolean anyHitboxIntersectsProjectile(Iterable<Shape> hitBoxes, Projectile target) {
        GameLog.debug.println("wack");
        boolean hitDetected = false;
        Rectangle targetHitbox = target.getHitbox();
        for (Shape hitBox : hitBoxes) {
            if (!hitBox.intersects(targetHitbox)) continue;
            hitDetected = true;
        }
        if (hitDetected) {
            if (target.canHitMobs) {
                return true;
            }
            CollisionFilter collisionFilter = this.owner.modifyChasingCollisionFilter(new CollisionFilter().projectileCollision(), null);
            return !this.level.collides((Line2D)new Line2D.Float(this.owner.x, this.owner.y, target.x, target.y), collisionFilter);
        }
        return false;
    }

    protected Stream<Mob> streamTargets(Shape hitbox) {
        Stream<Mob> targets = this.allowNullOwner && this.owner == null ? Stream.concat(this.level.entityManager.mobs.streamInRegionsShape(hitbox, 1), this.level.entityManager.players.streamInRegionsShape(hitbox, 1)) : GameUtils.streamTargets((Mob)this.owner, (Level)this.level, (Shape)hitbox);
        Stream<Projectile> projectiles = Stream.concat(this.level.entityManager.projectiles.streamInRegionsShape(this.circle, 0), this.level.entityManager.projectiles.streamInRegionsShape(this.circle, 0).filter(projectile -> projectile.canHit(this.owner)));
        if (this.owner != null) {
            if (this.getFirstPlayerOwner().getSelectedItem().getGndData().getString("BodyItem", "BodyGlaiveBasic").equalsIgnoreCase("BodyGlaiveBlock")) {
                if (!this.owner.buffManager.hasBuff(BuffRegistry.getBuff((String)"GlaiveBlockingStacks")) || this.owner.buffManager.getStacks(BuffRegistry.getBuff((String)"GlaiveBlockingStacks")) != this.owner.buffManager.getBuff(BuffRegistry.getBuff((String)"GlaiveBlockingStacks")).getMaxStacks()) {
                    try {
                        Projectile blocked = projectiles.filter(projectile -> this.circle.contains(projectile.getPositionPoint())).findFirst().get();
                        for (int i = 0; i < 9; ++i) {
                            this.level.entityManager.addParticle(blocked.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), blocked.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).color(new Color(255, 255, 255)).height(16.0f).lifeTime(850 + GameRandom.globalRandom.getIntBetween(0, 100)).givesLight(85).size((options, lifeTime, timeAlive, lifePercent) -> options.size(12)).sizeFades(1, 10).fadesAlphaTime(1, 500);
                        }
                        this.owner.getFirstPlayerOwner().getClient().network.sendPacket((Packet)new DeflectedProjectilePacket(blocked.getUniqueID(), this.level.getIdentifier()));
                        ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)"GlaiveBlockingStacks"), this.owner, 5.0f, (Attacker)this.owner);
                        this.owner.buffManager.addBuff(ab, true);
                        SoundManager.playSound((GameSound)GameResources.flick, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(1.0f).pitch(0.8f + (float)this.owner.buffManager.getStacks(BuffRegistry.getBuff((String)"GlaiveBlockingStacks")) / 10.0f));
                    }
                    catch (Exception blocked) {}
                }
            } else if (this.getFirstPlayerOwner().getSelectedItem().getGndData().getString("BodyItem", "BodyGlaiveBasic").equalsIgnoreCase("BodyShovelBlock")) {
                try {
                    Projectile blocked = projectiles.filter(projectile -> this.circle.contains(projectile.getPositionPoint())).filter(projectile -> projectile.canHit(this.owner)).filter(projectile -> projectile.getOwner() != this.owner).filter(projectile -> !(projectile instanceof ReflectedProjectile)).findFirst().get();
                    if (!(blocked instanceof ReflectedProjectile)) {
                        for (int i = 0; i < 9; ++i) {
                            this.level.entityManager.addParticle(blocked.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), blocked.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).color(new Color(255, 255, 255)).height(16.0f).lifeTime(850 + GameRandom.globalRandom.getIntBetween(0, 100)).givesLight(85).size((options, lifeTime, timeAlive, lifePercent) -> options.size(12)).sizeFades(1, 10).fadesAlphaTime(1, 500);
                        }
                        this.owner.getFirstPlayerOwner().getClient().network.sendPacket((Packet)new ReflectedProjectilePacket(blocked.getUniqueID(), this.level.getIdentifier(), this.owner.getFirstPlayerOwner().getPlayerSlot()));
                        ((Projectile)this.owner.getLevel().entityManager.projectiles.get(blocked.getUniqueID(), true)).remove();
                        SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(1.3f).pitch(2.0f));
                        SoundManager.playSound((GameSound)GameResources.bounce, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(0.4f).pitch(2.0f));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return targets;
    }

    public Stream<Projectile> streamProjectileTargets(Mob attacker, Level level, Shape hitBounds, int extraRegionRange) {
        GameLog.debug.println("wack33");
        if (attacker != null && level != null) {
            NetworkClient attackerClient = GameUtils.getAttackerClient((Mob)attacker);
            if (hitBounds == null) {
                return level.entityManager.projectiles.stream();
            }
            return level.entityManager.projectiles.streamInRegionsShape(hitBounds, extraRegionRange);
        }
        return Stream.empty();
    }

    protected Stream<Projectile> streamProjectileTargets(Shape hitbox) {
        GameLog.debug.println("wack3");
        Stream<Object> targets = this.allowNullOwner && this.owner == null ? Stream.concat(this.level.entityManager.projectiles.streamInRegionsShape(hitbox, 1), this.level.entityManager.projectiles.streamInRegionsShape(hitbox, 1)) : this.streamProjectileTargets(this.owner, this.level, hitbox, 0);
        return targets;
    }

    protected void handleHits(Iterable<Shape> hitboxes, Predicate<Mob> canHit, Function<Mob, Packet> attackContentSupplier, Function<Projectile, Packet> attackContentSuppliers) {
        block7: {
            block5: {
                ClientClient client;
                block6: {
                    GameLog.debug.println("wack4");
                    Predicate canHitP = null;
                    if (!this.isClient()) break block5;
                    if (this.handlingClient == null) break block6;
                    this.streamTargets(this.getHitboxesBounds(hitboxes)).filter(m -> !m.isPlayer || m == this.owner).filter(canHit).filter(m -> this.anyHitboxIntersects(hitboxes, (Mob)m)).forEach(m -> this.clientHit((Mob)m, attackContentSupplier == null ? null : (Packet)attackContentSupplier.apply((Mob)m)));
                    this.streamProjectileTargets(this.getHitboxesBounds(hitboxes)).filter(p -> !this.clientHandlesHit || !p.canHit(this.owner)).filter(canHitP).filter(p -> this.anyHitboxIntersectsProjectile(hitboxes, (Projectile)p)).forEach(p -> this.clientHitProjectile((Projectile)p, attackContentSupplier == null ? null : (Packet)attackContentSuppliers.apply((Projectile)p), false));
                    break block7;
                }
                if (!this.clientHandlesHit || (client = this.level.getClient().getClient()) == null || !client.hasSpawned() || client.isDead() || !this.canHitLocalClient(client) || !canHit.test((Mob)client.playerMob) || !this.anyHitboxIntersects(hitboxes, (Mob)client.playerMob)) break block7;
                this.clientHit((Mob)client.playerMob, attackContentSupplier == null ? null : attackContentSupplier.apply((Mob)client.playerMob));
                break block7;
            }
            if (this.isServer()) {
                if (this.handlingClient == null) {
                    this.streamTargets(this.getHitboxesBounds(hitboxes)).filter(m -> !this.clientHandlesHit || !m.isPlayer).filter(canHit).filter(m -> this.anyHitboxIntersects(hitboxes, (Mob)m)).forEach(m -> this.serverHit((Mob)m, attackContentSupplier == null ? null : (Packet)attackContentSupplier.apply((Mob)m), false));
                }
                if (this.hitsObjects) {
                    for (Shape hitbox : hitboxes) {
                        for (LevelObjectHit hit : this.level.getCollisions(hitbox, new CollisionFilter().attackThroughCollision(tp -> this.canHitObjectFilter(tp.object())))) {
                            if (hit.invalidPos() || !this.canHit(hit)) continue;
                            this.hit(hit);
                        }
                    }
                }
            }
        }
    }

    protected void handleHits(Shape hitbox, Predicate<Mob> canHit, Function<Mob, Packet> attackContentSupplier) {
        GameLog.debug.println("wack5");
        Function<Projectile, Packet> attackContentSupplieras = null;
        this.handleHits(Collections.singleton(hitbox), canHit, attackContentSupplier, attackContentSupplieras);
    }

    public void clientHitProjectile(Projectile target, Packet content, boolean clientSubmitted) {
        GameLog.debug.println("wack6");
        target.remove();
        ((Projectile)this.level.entityManager.projectiles.get(target.getUniqueID(), true)).remove();
    }
}

