/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.buffs;

import java.util.concurrent.atomic.AtomicBoolean;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.gfx.gameTooltips.ListGameTooltips;

public class DowsingPickaxeCooldown
extends Buff {
    public DowsingPickaxeCooldown() {
        this.canCancel = false;
        this.isImportant = true;
    }

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.SLOW, (Object)Float.valueOf(0.05f * (float)buff.getStacks()));
        buff.setModifier(BuffModifiers.MINING_SPEED, (Object)Float.valueOf(-0.05f));
    }

    public int getStackSize(ActiveBuff buff) {
        return 5;
    }

    public boolean overridesStackDuration() {
        return true;
    }

    public void onStacksUpdated(ActiveBuff buff, ActiveBuff other) {
        if (buff.getStacks() > 0) {
            buff.setDurationLeftSeconds(10.0f);
            buff.setModifier(BuffModifiers.SLOW, (Object)Float.valueOf(0.05f * (float)buff.getStacks()));
        }
    }

    public int getRemainingStacksDuration(ActiveBuff buff, AtomicBoolean sendUpdatePacket) {
        return 10;
    }

    public ListGameTooltips getTooltip(ActiveBuff ab, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips(this.getDisplayName());
        tooltips.add(Localization.translate((String)"buff", (String)"DowsingPickaxeCooldownTip"));
        tooltips.add(Localization.translate((String)"buff", (String)"DowsingPickaxeCooldownTip2", (String)"value", (Object)(ab.getStacks() * 5)));
        return tooltips;
    }
}

