/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.buffs;

import java.util.concurrent.atomic.AtomicBoolean;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.gfx.gameTooltips.ListGameTooltips;

public class AccelerationPickaxeStacks
extends Buff {
    public AccelerationPickaxeStacks() {
        this.canCancel = false;
        this.isImportant = true;
    }

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.SLOW, (Object)Float.valueOf(0.0f));
    }

    public int getStackSize(ActiveBuff buff) {
        return 100;
    }

    public void onStacksUpdated(ActiveBuff buff, ActiveBuff other) {
        if (buff.owner.getWorldTime() > buff.getGndData().getLong("lastTime") + 60000L) {
            buff.setDurationLeftSeconds(0.0f);
            buff.setStacks(0, 0, null);
        } else if (buff.getStacks() > 0) {
            float mult = Math.max(0.3f, 1.0f - (float)buff.getStacks() / 100.0f);
            buff.setDurationLeftSeconds(15.0f * mult);
        }
    }

    public boolean shouldDrawDuration(ActiveBuff buff) {
        return false;
    }

    public boolean overridesStackDuration() {
        return true;
    }

    public int getRemainingStacksDuration(ActiveBuff buff, AtomicBoolean sendUpdatePacket) {
        return 15;
    }

    public ListGameTooltips getTooltip(ActiveBuff ab, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips(this.getDisplayName());
        tooltips.add(Localization.translate((String)"buff", (String)"AccelerationPickaxeStacksTip"));
        tooltips.add(Localization.translate((String)"buff", (String)"AccelerationPickaxeStacksTip2", (String)"value", (Object)ab.getStacks()));
        return tooltips;
    }
}

