/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.buffs;

import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;
import necesse.gfx.gameTooltips.ListGameTooltips;

public class AccelerationPickaxeBuff
extends Buff {
    int stacks = 1;

    public AccelerationPickaxeBuff() {
        this.canCancel = false;
        this.isImportant = true;
    }

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.MINING_SPEED, (Object)Float.valueOf(0.01f * (float)buff.getGndData().getInt("stacks", 1)));
        buff.setModifier(BuffModifiers.TOOL_DAMAGE, (Object)Float.valueOf((float)buff.getGndData().getInt("stacks", 1) / 100.0f));
    }

    public void clientTick(ActiveBuff buff) {
        if (buff.owner.isVisible()) {
            Mob owner = buff.owner;
            if (buff.owner.getWorldTime() % 2L == 0L) {
                owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(new Color(255, 152, 101)).height(16.0f);
            }
        }
    }

    public ListGameTooltips getTooltip(ActiveBuff ab, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips(this.getDisplayName());
        tooltips.add(Localization.translate((String)"buff", (String)"AccelerationPickaxeBuffTip", (String)"value", (Object)ab.getGndData().getInt("stacks", 1)));
        return tooltips;
    }
}

