/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.tiles;

import java.awt.Color;
import java.awt.Point;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameTextureSection;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;
import necesse.level.gameObject.GameObject;
import necesse.level.gameTile.GrassTile;
import necesse.level.gameTile.TerrainSplatterTile;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.SimulatePriorityList;

public class ScorchedGrassTile
extends TerrainSplatterTile {
    public static double growChance = GameMath.getAverageSuccessRuns((double)7000.0);
    public static double spreadChance = GameMath.getAverageSuccessRuns((double)850.0);
    private final GameRandom drawRandom;

    public ScorchedGrassTile() {
        super(false, "scorchedgrass");
        this.mapColor = new Color(125, 65, 65);
        this.canBeMined = true;
        this.drawRandom = new GameRandom();
        this.isOrganic = true;
    }

    public LootTable getLootTable(Level level, int tileX, int tileY) {
        return new LootTable(new LootItemInterface[]{new ChanceLootItem(0.04f, "scorchedgrassseed")});
    }

    public void addSimulateLogic(Level level, int x, int y, long ticks, SimulatePriorityList list, boolean sendChanges) {
        ScorchedGrassTile.addSimulateGrow(level, x, y, growChance, ticks, "scorchedgrass", list, sendChanges);
    }

    public static void addSimulateGrow(Level level, int tileX, int tileY, double growChance, long ticks, String growObjectID, SimulatePriorityList list, boolean sendChanges) {
        ScorchedGrassTile.addSimulateGrow(level, tileX, tileY, growChance, ticks, growObjectID, (object, l, x, y, r) -> object.canPlace(l, x, y, r, false) == null, list, sendChanges);
    }

    public static void addSimulateGrow(Level level, int tileX, int tileY, double growChance, long ticks, String growObjectID, GrassTile.CanPlacePredicate canPlace, SimulatePriorityList list, boolean sendChanges) {
        GameObject obj;
        double runs;
        long remainingTicks;
        if (level.getObjectID(tileX, tileY) == 0 && (remainingTicks = (long)((double)ticks - (runs = Math.max(1.0, GameMath.getRunsForSuccess((double)growChance, (double)GameRandom.globalRandom.nextDouble()))))) > 0L && canPlace.check(obj = ObjectRegistry.getObject((int)ObjectRegistry.getObjectID((String)growObjectID)), level, tileX, tileY, 0)) {
            list.add(tileX, tileY, remainingTicks, () -> {
                if (canPlace.check(obj, level, tileX, tileY, 0)) {
                    obj.placeObject(level, tileX, tileY, 0, false);
                    level.objectLayer.setIsPlayerPlaced(tileX, tileY, false);
                    if (sendChanges) {
                        level.sendObjectUpdatePacket(tileX, tileY);
                    }
                }
            });
        }
    }

    public double spreadToDirtChance() {
        return spreadChance;
    }

    public void tick(Level level, int x, int y) {
        GameObject grass;
        if (level.isServer() && level.getObjectID(x, y) == 0 && GameRandom.globalRandom.getChance(growChance) && (grass = ObjectRegistry.getObject((int)ObjectRegistry.getObjectID((String)"scorchedgrass"))).canPlace(level, x, y, 0, false) == null) {
            grass.placeObject(level, x, y, 0, false);
            level.objectLayer.setIsPlayerPlaced(x, y, false);
            level.sendObjectUpdatePacket(x, y);
        }
    }

    public void tickEffect(Level level, int x, int y) {
        super.tickEffect(level, x, y);
        if (GameRandom.globalRandom.getChance(0.025f) && !level.getObject(x, y).drawsFullTile() && level.getLightLevel(x, y).getLevel() > 0.0f) {
            int posX = x * 32 + GameRandom.globalRandom.nextInt(32);
            int posY = y * 32 + GameRandom.globalRandom.nextInt(32);
            boolean mirror = GameRandom.globalRandom.nextBoolean();
            level.entityManager.addParticle((float)posX, (float)(posY + 30), Particle.GType.COSMETIC).sprite(GameResources.fogParticles.sprite(GameRandom.globalRandom.nextInt(4), 0, 32, 16)).fadesAlpha(0.4f, 0.4f).size((options, lifeTime, timeAlive, lifePercent) -> {}).height(30.0f).dontRotate().movesConstant(GameRandom.globalRandom.getFloatBetween(2.0f, 5.0f) * ((Float)GameRandom.globalRandom.getOneOf((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(-1.0f)})).floatValue(), 0.0f).modify((options, lifeTime, timeAlive, lifePercent) -> options.mirror(mirror, false)).lifeTime(3000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getTerrainSprite(GameTextureSection terrainTexture, Level level, int tileX, int tileY) {
        int tile;
        GameRandom gameRandom = this.drawRandom;
        synchronized (gameRandom) {
            tile = this.drawRandom.seeded(ScorchedGrassTile.getTileSeed((int)tileX, (int)tileY)).nextInt(terrainTexture.getHeight() / 32);
        }
        return new Point(0, tile);
    }

    public int getTerrainPriority() {
        return 100;
    }
}

