/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.presets.WorldPresets;

import java.awt.Dimension;
import java.awt.Point;
import necesse.engine.gameLoop.tickManager.PerformanceTimerManager;
import necesse.engine.registries.BiomeRegistry;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.engine.world.biomeGenerator.BiomeGeneratorStack;
import necesse.engine.world.worldPresets.LevelPresetsRegion;
import necesse.engine.world.worldPresets.WorldPreset;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.presets.Preset;
import necesse.level.maps.presets.PresetUtils;
import scorchedbiome.presets.DragonArenaPreset;
import scorchedbiome.registry.SchBiomes;

public class DragonArenaWorldPreset
extends WorldPreset {
    protected Dimension size = new Dimension(28, 28);

    public boolean shouldAddToRegion(LevelPresetsRegion presetsRegion) {
        return presetsRegion.hasAnyOfBiome(SchBiomes.SCORCHED_BIOME.getID()) && presetsRegion.identifier.equals(LevelIdentifier.SURFACE_IDENTIFIER) || presetsRegion.identifier.equals(LevelIdentifier.CAVE_IDENTIFIER);
    }

    public void addToRegion(GameRandom random, LevelPresetsRegion presetsRegion, BiomeGeneratorStack generatorStack, PerformanceTimerManager performanceTimer) {
        int total = DragonArenaWorldPreset.getTotalBiomePoints((GameRandom)random, (LevelPresetsRegion)presetsRegion, (Biome)SchBiomes.SCORCHED_BIOME, (float)0.008f);
        for (int i = 0; i < total; ++i) {
            Point tile = DragonArenaWorldPreset.findRandomBiomePresetTile((GameRandom)random, (LevelPresetsRegion)presetsRegion, (BiomeGeneratorStack)generatorStack, (Biome)BiomeRegistry.FOREST, (int)20, (Dimension)this.size, (String[])new String[]{"loot", "villages"}, (tileX, tileY) -> this.runCornerCheck(tileX, tileY, this.size.width, this.size.height, (tileX1, tileY1) -> generatorStack.getLazyBiomeID(tileX1, tileY1) == BiomeRegistry.FOREST.getID() && !generatorStack.isSurfaceOceanOrRiver(tileX1, tileY1)));
            if (tile == null) continue;
            presetsRegion.addPreset((WorldPreset)this, tile.x, tile.y, this.size, new String[]{"loot", "villages"}, (random1, level, timer) -> {
                WorldPreset.ensureRegionsAreGenerated((Level)level, (int)tile.x, (int)tile.y, (int)this.size.width, (int)this.size.height);
                DragonArenaPreset preset = new DragonArenaPreset(random1);
                PresetUtils.clearMobsInPreset((Preset)preset, (Level)level, (int)tile.x, (int)tile.y);
                preset.applyToLevel(level, tile.x, tile.y);
            }).setRemoveIfWithinSpawnRegionRange(-1);
        }
    }
}

