/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.presets;

import java.awt.Point;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.engine.util.GameRandom;
import necesse.level.maps.presets.Preset;

public class DragonArenaPreset
extends Preset {
    public DragonArenaPreset(GameRandom random) {
        this(28, random);
    }

    private DragonArenaPreset(int size, GameRandom random) {
        super(size, size);
        int mid = size / 2;
        int maxDistance = size / 2 * 32;
        int dungeonFloor = TileRegistry.getTileID((String)"deepstonefloor");
        int dungeonWall = ObjectRegistry.getObjectID((String)"deepstonewall");
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                float chance;
                float distance = (float)new Point(mid * 32 + 16, mid * 32 + 16).distance(x * 32 + 16, y * 32 + 16);
                float distancePerc = distance / (float)maxDistance;
                if (distancePerc < 0.4f) {
                    this.setTile(x, y, dungeonFloor);
                    this.setObject(x, y, 0);
                } else if (distancePerc <= 1.0f && random.getChance(chance = Math.abs((distancePerc - 0.5f) * 2.0f - 1.0f) * 2.0f)) {
                    this.setTile(x, y, dungeonFloor);
                    this.setObject(x, y, 0);
                }
                if (!(distance < (float)maxDistance) || !(distance >= (float)(maxDistance - 40)) || !random.getChance(0.4f)) continue;
                this.setObject(x, y, dungeonWall);
            }
        }
        int lightingOffset = 3;
        int pillarsOffset = 7;
        this.setLighting(mid - lightingOffset - 1, mid - lightingOffset - 1);
        this.setLighting(mid - lightingOffset - 1, mid + lightingOffset);
        this.setLighting(mid + lightingOffset, mid - lightingOffset - 1);
        this.setLighting(mid + lightingOffset, mid + lightingOffset);
        this.setObject(mid - pillarsOffset - 1, mid - pillarsOffset - 1, ObjectRegistry.getObjectID((String)"cryptcolumn"));
        this.setObject(mid - pillarsOffset - 1, mid + pillarsOffset, ObjectRegistry.getObjectID((String)"cryptcolumn"));
        this.setObject(mid + pillarsOffset, mid - pillarsOffset - 1, ObjectRegistry.getObjectID((String)"cryptcolumn"));
        this.setObject(mid + pillarsOffset, mid + pillarsOffset, ObjectRegistry.getObjectID((String)"cryptcolumn"));
        this.setObject(mid, mid, ObjectRegistry.getObjectID((String)"scorchedpedestal"));
        int mobOffset = 5;
        this.addMob("enchantedzombie", mid - mobOffset, mid - mobOffset, false);
        this.addMob("enchantedzombie", mid + mobOffset, mid - mobOffset, false);
        this.addMob("enchantedzombie", mid - mobOffset, mid + mobOffset, false);
        this.addMob("enchantedzombie", mid + mobOffset, mid + mobOffset, false);
        this.addCanApplyRectPredicate(-4, -4, this.width + 8, this.height + 8, 0, (level, levelStartX, levelStartY, levelEndX, levelEndY, dir) -> {
            for (int x = levelStartX; x <= levelEndX; ++x) {
                for (int y = levelStartY; y <= levelEndY; ++y) {
                    if (!level.isLiquidTile(x, y)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private void setLighting(int x, int y) {
        this.setObject(x, y, ObjectRegistry.getObjectID((String)"dungeoncandelabra"));
    }
}

