/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.objects;

import java.awt.Color;
import necesse.engine.registries.ObjectLayerRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.GrassObject;
import necesse.level.maps.Level;
import scorchedbiome.registry.SchTiles;

public class SurfaceScorchedGrassObject
extends GrassObject {
    public SurfaceScorchedGrassObject() {
        super("scorchedgrass", 1);
        this.mapColor = new Color(135, 85, 85);
    }

    public LootTable getLootTable(Level level, int layerID, int tileX, int tileY) {
        if (level.objectLayer.isPlayerPlaced(tileX, tileY)) {
            return super.getLootTable(level, layerID, tileX, tileY);
        }
        String seedItem = "scorchedgrassseed";
        return new LootTable(new LootItemInterface[]{new ChanceLootItem(0.01f, seedItem)});
    }

    public boolean canPlaceOn(Level level, int layerID, int x, int y, GameObject other) {
        return other.getID() == 0 || !other.getValidObjectLayers().contains(ObjectLayerRegistry.TILE_LAYER);
    }

    public String canPlace(Level level, int layerID, int x, int y, int rotation, boolean byPlayer, boolean ignoreOtherLayers) {
        String error = super.canPlace(level, layerID, x, y, rotation, byPlayer, ignoreOtherLayers);
        if (error != null) {
            return error;
        }
        if (level.getObjectID(ObjectLayerRegistry.TILE_LAYER, x, y) != 0) {
            return "occupied";
        }
        if (byPlayer && level.getTile((int)x, (int)y).isOrganic) {
            return null;
        }
        int tileID = level.getTileID(x, y);
        return tileID != SchTiles.scorchedGrassID && tileID != TileRegistry.overgrownGrassID ? "wrongtile" : null;
    }

    public boolean isValid(Level level, int layerID, int x, int y) {
        if (!super.isValid(level, layerID, x, y)) {
            return false;
        }
        if (level.getObjectID(ObjectLayerRegistry.TILE_LAYER, x, y) != 0) {
            return false;
        }
        if (level.objectLayer.isPlayerPlaced(layerID, x, y) && level.getTile((int)x, (int)y).isOrganic) {
            return true;
        }
        int tileID = level.getTileID(x, y);
        return tileID == SchTiles.scorchedGrassID || tileID == TileRegistry.overgrownGrassID;
    }
}

