/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.objects;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.ToolType;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.ObjectDamagedTextureArray;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import scorchedbiome.mobs.NightDragonMob;
import scorchedbiome.mobs.RejexBossMob;

public class ScorchedPedestalObject
extends GameObject {
    public ObjectDamagedTextureArray texture;
    protected boolean hasRotation;
    protected int yOffset = -3;

    public ScorchedPedestalObject() {
        super(new Rectangle(2, 5, 28, 22));
        this.toolType = ToolType.UNBREAKABLE;
        this.mapColor = new Color(102, 102, 102);
        this.isLightTransparent = true;
        this.lightLevel = 255;
        this.hoverHitbox = new Rectangle(0, -32, 32, 64);
        this.collision = new Rectangle(0, -8, 32, 32);
        this.lightHue = 0.0f;
        this.lightSat = 0.0f;
    }

    public void loadTextures() {
        super.loadTextures();
        this.texture = ObjectDamagedTextureArray.loadAndApplyOverlay((GameObject)this, (String)"objects/scorchedpedestal");
    }

    public void tickEffect(Level level, int layerID, int tileX, int tileY) {
        super.tickEffect(level, layerID, tileX, tileY);
        Rectangle bounds = GameUtils.rangeTileBounds((int)(tileX * 32 + 16), (int)(tileY * 32 + 16), (int)50);
        if (level.entityManager.mobs.streamInRegionsShape((Shape)bounds, 0).anyMatch(m -> m instanceof RejexBossMob)) {
            level.entityManager.addParticle((float)(tileX * 32 + GameRandom.globalRandom.getIntBetween(6, 28)), (float)(tileY * 32 + GameRandom.globalRandom.getIntBetween(10, 16) + 28), GameRandom.globalRandom.getChance(0.75f) ? Particle.GType.CRITICAL : Particle.GType.COSMETIC).movesConstant(GameRandom.globalRandom.getFloatBetween(-1.0f, 1.0f), GameRandom.globalRandom.getFloatBetween(-1.0f, 1.0f)).color(new Color(0, 153, 0)).sizeFades(10, 14).heightMoves(48.0f, 70.0f).lifeTime(2000);
        } else if (level.entityManager.mobs.streamInRegionsShape((Shape)bounds, 0).anyMatch(m -> m instanceof NightDragonMob)) {
            level.entityManager.addParticle((float)(tileX * 32 + GameRandom.globalRandom.getIntBetween(6, 28)), (float)(tileY * 32 + GameRandom.globalRandom.getIntBetween(10, 16) + 28), GameRandom.globalRandom.getChance(0.75f) ? Particle.GType.CRITICAL : Particle.GType.COSMETIC).movesConstant(GameRandom.globalRandom.getFloatBetween(-1.0f, 1.0f), GameRandom.globalRandom.getFloatBetween(-1.0f, 1.0f)).color(new Color(0, 0, 0)).sizeFades(10, 14).heightMoves(48.0f, 70.0f).lifeTime(2000);
        }
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        TextureDrawOptionsEnd drawOptions;
        GameLight light = level.getLightLevel(tileX, tileY);
        GameTexture texture = this.texture.getDamagedTexture((GameObject)this, level, tileX, tileY);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY) - texture.getHeight() + 32;
        if (this.hasRotation) {
            byte rotation = level.getObjectRotation(tileX, tileY);
            int spriteWidth = texture.getWidth() / 4;
            int xOffset = (spriteWidth - 32) / 2;
            drawOptions = texture.initDraw().sprite(rotation % 4, 0, spriteWidth, texture.getHeight()).light(light).pos(drawX - xOffset, drawY + this.yOffset);
        } else {
            int rotation = (texture.getWidth() - 32) / 2;
            drawOptions = texture.initDraw().light(light).pos(drawX - rotation, drawY + this.yOffset);
        }
        list.add(new LevelSortedDrawable(this, tileX, tileY){

            public int getSortY() {
                return 16;
            }

            public void draw(TickManager tickManager) {
                drawOptions.draw();
            }
        });
    }

    public void drawPreview(Level level, int tileX, int tileY, int rotation, float alpha, PlayerMob player, GameCamera camera) {
        GameTexture texture = this.texture.getDamagedTexture(0.0f);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY) - texture.getHeight() + 32;
        if (this.hasRotation) {
            int spriteWidth = texture.getWidth() / 4;
            int xOffset = (spriteWidth - 32) / 2;
            texture.initDraw().sprite(rotation % 4, 0, spriteWidth, texture.getHeight()).alpha(alpha).draw(drawX - xOffset, drawY + this.yOffset);
        } else {
            int spriteWidth = (texture.getWidth() - 32) / 2;
            texture.initDraw().alpha(alpha).draw(drawX - spriteWidth, drawY + this.yOffset);
        }
    }

    public boolean canInteract(Level level, int x, int y, PlayerMob player) {
        return true;
    }

    public String getInteractTip(Level level, int x, int y, PlayerMob perspective, boolean debug) {
        return Localization.translate((String)"controls", (String)"activatetip");
    }

    public void interact(Level level, int x, int y, PlayerMob player) {
        super.interact(level, x, y, player);
        if (!this.trySummonRejex(level, x, y, player)) {
            Item item = ItemRegistry.getItem((String)"paladinsjewel");
            if (level.getWorldEntity().isNight() || level.isCave) {
                if (!player.isItemOnCooldown(item)) {
                    if (player.getInv().removeItems(item, 1, false, false, false, false, "use") > 0) {
                        player.startItemCooldown(item, 2000);
                        if (level.isServer()) {
                            System.out.println("Night Dragon has been summoned at " + level.getIdentifier() + ".");
                            NightDragonMob mob = (NightDragonMob)MobRegistry.getMob((String)"nightdragon", (Level)level);
                            level.entityManager.addMob((Mob)mob, (float)(x * 32 + 16), (float)(y * 32 + 16));
                            level.getServer().network.sendToClientsWithEntity((Packet)new PacketChatMessage((GameMessage)new LocalMessage("misc", "bosssummon", "name", MobRegistry.getLocalization((String)"nightdragon"))), (RegionPositionGetter)mob);
                        }
                    } else if (player.isServerClient()) {
                        player.getServerClient().sendChatMessage((GameMessage)new LocalMessage("misc", "bossmissingitem"));
                    }
                }
            } else if (player.isServerClient()) {
                player.getServerClient().sendChatMessage((GameMessage)new LocalMessage("itemtooltip", "portalnotnight"));
            }
        }
    }

    public boolean trySummonRejex(Level level, int x, int y, PlayerMob player) {
        Item item = ItemRegistry.getItem((String)"emeraldjewel");
        if (!player.isItemOnCooldown(item) && player.getInv().removeItems(item, 1, false, false, false, false, "use") > 0) {
            player.startItemCooldown(item, 2000);
            if (level.isServer()) {
                System.out.println("Rejex has been summoned at " + level.getIdentifier() + ".");
                RejexBossMob mob = (RejexBossMob)MobRegistry.getMob((String)"rejexdragon", (Level)level);
                level.entityManager.addMob((Mob)mob, (float)(x * 32 + 16), (float)(y * 32 + 16));
                level.getServer().network.sendToClientsWithEntity((Packet)new PacketChatMessage((GameMessage)new LocalMessage("misc", "bosssummon", "name", MobRegistry.getLocalization((String)"rejexdragon"))), (RegionPositionGetter)mob);
            }
            return true;
        }
        return false;
    }
}

