/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.mobs.summons;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.AINodeResult;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.Blackboard;
import necesse.entity.mobs.ai.behaviourTree.composites.SelectorAINode;
import necesse.entity.mobs.ai.behaviourTree.composites.SequenceAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.FollowerBaseSetterAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.FollowerFocusTargetSetterAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.PlayerFollowerAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.SummonTargetFinderAINode;
import necesse.entity.mobs.mobMovement.MobMovement;
import necesse.entity.mobs.mobMovement.MobMovementRelative;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.FlyingAttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import scorchedbiome.mobs.RejexBossMob;
import scorchedbiome.projectiles.RejexFireProjectile;

public class RejexSummonMob
extends FlyingAttackingFollowingMob {
    public static int FLY_HEIGHT = 150;

    public RejexSummonMob() {
        super(100);
        this.moveAccuracy = 60;
        this.setSpeed(200.0f);
        this.setArmor(20);
        this.setFriction(1.0f);
        this.setKnockbackModifier(0.0f);
        this.collision = new Rectangle(-75, -60, 150, 120);
        this.hitBox = new Rectangle(-75, -60, 150, 120);
        this.selectBox = new Rectangle(-80, -80 - FLY_HEIGHT, 160, 160 + FLY_HEIGHT);
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new RejexSummonMobAI(576, 2048, 256));
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.roar, (SoundEffect)SoundEffect.globalEffect().pitch(0.8f));
        }
    }

    public boolean canBePushed(Mob other) {
        return false;
    }

    public GameDamage getCollisionDamage(Mob target, boolean fromPacket, ServerClient packetSubmitter) {
        return this.summonDamage;
    }

    public int getCollisionKnockback(Mob target) {
        return 150;
    }

    public void setFacingDir(float deltaX, float deltaY) {
        if (deltaX < 0.0f) {
            this.setDir(0);
        } else if (deltaX > 0.0f) {
            this.setDir(1);
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), RejexBossMob.texture, i, 3, 112, this.x, this.y, 10.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 160;
        int drawY = camera.getDrawY(y) - 160 - FLY_HEIGHT;
        int dir = this.getDir();
        long time = level.getWorldEntity().getTime() % 350L;
        int sprite = time < 100L ? 0 : (time < 200L ? 1 : (time < 300L ? 2 : 3));
        float rotate = Math.min(10.0f, this.dx / 5.0f);
        TextureDrawOptionsEnd optionsLight = RejexBossMob.texture_light.initDraw().sprite(sprite, 0, 320).mirror(dir == 0, false).rotate(rotate, 160, 100).pos(drawX, drawY);
        TextureDrawOptionsEnd options = RejexBossMob.texture.initDraw().sprite(sprite, 0, 320).light(light).mirror(dir == 0, false).rotate(rotate, 160, 100).pos(drawX, drawY);
        TextureDrawOptions shadowOptions = this.getShadowDrawOptions(x, y, light, camera);
        topList.add(arg_0 -> RejexSummonMob.lambda$addDrawables$0(shadowOptions, (DrawOptions)options, (DrawOptions)optionsLight, arg_0));
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = RejexBossMob.texture_shadow;
        int drawX = camera.getDrawX(x) - shadowTexture.getWidth() / 2;
        int drawY = camera.getDrawY(y) - shadowTexture.getHeight() / 2 + 10;
        return shadowTexture.initDraw().light(light).pos(drawX, drawY);
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadowOptions, DrawOptions options, DrawOptions optionsLight, TickManager tm) {
        shadowOptions.draw();
        options.draw();
        optionsLight.draw();
    }

    public class RejexSummonMobAI
    extends SelectorAINode<RejexSummonMob> {
        public RejexSummonMobAI(int searchDistance, int teleportDistance, int stoppingDistance) {
            SequenceAINode chaserSequence = new SequenceAINode();
            chaserSequence.addChild((AINode)new FollowerBaseSetterAINode());
            chaserSequence.addChild((AINode)new FollowerFocusTargetSetterAINode<RejexSummonMob>(){

                public Mob getCustomFocus() {
                    return RejexSummonMobAI.this.getCustomFocus();
                }
            });
            chaserSequence.addChild((AINode)new SummonTargetFinderAINode(searchDistance));
            chaserSequence.addChild(new RejexSummonAttackMobAI());
            this.addChild((AINode)chaserSequence);
            this.addChild((AINode)new PlayerFollowerAINode(teleportDistance, stoppingDistance));
        }

        public Mob getCustomFocus() {
            return null;
        }
    }

    public class RejexSummonAttackMobAI<T extends RejexSummonMob>
    extends AINode<T> {
        private final ArrayList<AttackRotation> attackRotations = new ArrayList();
        private int currentRotation;

        public RejexSummonAttackMobAI() {
            this.attackRotations.add(new FlyAroundAttackRotation());
            this.attackRotations.add(new AttackPlayerRotation());
            this.attackRotations.add(new FlyAroundAttackRotation());
            this.attackRotations.add(new FireBarrageAttackRotation());
            this.attackRotations.add(new AttackPlayerRotation());
            this.currentRotation = 0;
        }

        protected void onRootSet(AINode<T> root, T mob, Blackboard<T> blackboard) {
            if (mob.isServer()) {
                this.attackRotations.get(this.currentRotation).start();
            }
        }

        public void init(T mob, Blackboard<T> blackboard) {
        }

        public AINodeResult tick(T mob, Blackboard<T> blackboard) {
            Mob target;
            if (this.attackRotations.get(this.currentRotation).isOver()) {
                this.currentRotation = (this.currentRotation + 1) % this.attackRotations.size();
                this.attackRotations.get(this.currentRotation).start();
            }
            if ((target = (Mob)blackboard.getOrDefault((Object)"currentTarget", null)) == null) {
                return AINodeResult.FAILURE;
            }
            this.attackRotations.get(this.currentRotation).tick(target);
            return AINodeResult.SUCCESS;
        }

        private void shotFire(RejexSummonMob rejexMob, Mob target, int speed, GameDamage damage) {
            int distance;
            float angle;
            if (target == null) {
                angle = GameRandom.globalRandom.getFloatBetween(0.0f, 360.0f);
                distance = GameRandom.globalRandom.getIntBetween(8, 256);
            } else {
                float targetPredictedX = target.x;
                float targetPredictedY = target.y;
                float targetDistance = rejexMob.getDistance(target);
                float time = targetDistance / (float)speed;
                angle = (float)Math.toDegrees(Math.atan2((targetPredictedY += target.dy * time * 0.2f) - rejexMob.y, (targetPredictedX += target.dx * time * 0.2f) - rejexMob.x));
                distance = (int)((float)target.getFlyingHeight() + rejexMob.getDistance(targetPredictedX, targetPredictedY) + (float)GameRandom.globalRandom.getIntBetween(40, 120));
            }
            angle = GameRandom.globalRandom.getFloatOffset(angle, 5.0f);
            float targetX = rejexMob.x + GameMath.cos((float)angle) * 100.0f;
            float targetY = rejexMob.y + GameMath.sin((float)angle) * 100.0f;
            RejexFireProjectile projectile = new RejexFireProjectile(rejexMob.x, rejexMob.y, targetX, targetY, speed, distance, damage, (Mob)rejexMob);
            rejexMob.getLevel().entityManager.projectiles.add((Entity)projectile);
        }

        private class FlyAroundAttackRotation
        extends AttackRotation {
            private final Point[] positionRotation;
            private int currentPoint;
            private int timer;

            private FlyAroundAttackRotation() {
                this.positionRotation = new Point[]{new Point(260, 260), new Point(-260, -180), new Point(260, -260), new Point(-260, 180)};
            }

            @Override
            public void start() {
                this.timer = 0;
            }

            @Override
            public void tick(Mob target) {
                this.timer += 50;
                if (RejexSummonMob.this.hasArrivedAtTarget() && RejexSummonMob.this.getDistance(RejexSummonMob.this.getFollowingMob()) > 128.0f) {
                    this.currentPoint = (this.currentPoint + 1) % this.positionRotation.length;
                    RejexSummonAttackMobAI.this.shotFire(RejexSummonMob.this, target, 250, RejexSummonMob.this.summonDamage);
                }
                Point point = this.positionRotation[this.currentPoint];
                RejexSummonMob.this.setMovement((MobMovement)new MobMovementRelative(target, (float)point.x, (float)point.y));
            }

            @Override
            public boolean isOver() {
                return (float)this.timer > 5000.0f;
            }
        }

        private class AttackPlayerRotation
        extends AttackRotation {
            private int timer;

            private AttackPlayerRotation() {
            }

            @Override
            public void start() {
                this.timer = 0;
            }

            @Override
            public void tick(Mob target) {
                this.timer += 50;
                RejexSummonMob.this.setMovement((MobMovement)new MobMovementRelative(target, 0.0f, 0.0f));
            }

            @Override
            public boolean isOver() {
                return (float)this.timer > 1000.0f;
            }
        }

        private class FireBarrageAttackRotation
        extends AttackRotation {
            private int timer;

            private FireBarrageAttackRotation() {
            }

            @Override
            public void start() {
                this.timer = 0;
            }

            @Override
            public void tick(Mob target) {
                this.timer += 50;
                if (this.timer % 300 == 0) {
                    RejexSummonAttackMobAI.this.shotFire(RejexSummonMob.this, target, GameRandom.globalRandom.getIntBetween(250, 300), RejexSummonMob.this.summonDamage);
                }
            }

            @Override
            public boolean isOver() {
                return (float)this.timer > 10000.0f;
            }
        }

        private abstract class AttackRotation {
            private AttackRotation() {
            }

            public abstract void start();

            public abstract void tick(Mob var1);

            public abstract boolean isOver();
        }
    }
}

