/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.mobs;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import necesse.engine.DifficultyBasedGetter;
import necesse.engine.achievements.AchievementManager;
import necesse.engine.eventStatusBars.EventStatusBarManager;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.MusicRegistry;
import necesse.engine.sound.GameMusic;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaxHealthGetter;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MobHealthScaling;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.AINodeResult;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.Blackboard;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.BossNearbyBuff;
import necesse.entity.mobs.hostile.bosses.FlyingBossMob;
import necesse.entity.mobs.mobMovement.MobMovement;
import necesse.entity.mobs.mobMovement.MobMovementRelative;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.LootItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import scorchedbiome.projectiles.RejexFireProjectile;

public class RejexBossMob
extends FlyingBossMob {
    public static LootTable lootTable = new LootTable(new LootItemInterface[]{new LootItem("haydexstaff", new GNDItemMap().setInt("upgradeLevel", 100))});
    public static LootTable privateLootTable = new LootTable();
    protected MobHealthScaling scaling = new MobHealthScaling((Mob)this);
    public static GameDamage collisionDamage = new GameDamage(200.0f);
    public static GameDamage projectileDamage = new GameDamage(60.0f);
    public static MaxHealthGetter MAX_HEALTH = new MaxHealthGetter(20000, 25000, 30000, 35000, 40000);
    public static GameTexture texture;
    public static GameTexture texture_light;
    public static GameTexture texture_shadow;
    public static GameTexture texture_icon;
    public static int FLY_HEIGHT;

    public RejexBossMob() {
        super(100);
        this.difficultyChanges.setMaxHealth((DifficultyBasedGetter)MAX_HEALTH);
        this.moveAccuracy = 60;
        this.setSpeed(200.0f);
        this.setArmor(20);
        this.setFriction(1.0f);
        this.setKnockbackModifier(0.0f);
        this.collision = new Rectangle(-75, -60, 150, 120);
        this.hitBox = new Rectangle(-75, -60, 150, 120);
        this.selectBox = new Rectangle(-80, -80 - FLY_HEIGHT, 160, 160 + FLY_HEIGHT);
    }

    public void setupHealthPacket(PacketWriter writer, boolean isFull) {
        this.scaling.setupHealthPacket(writer, isFull);
        super.setupHealthPacket(writer, isFull);
    }

    public void applyHealthPacket(PacketReader reader, boolean isFull) {
        this.scaling.applyHealthPacket(reader, isFull);
        super.applyHealthPacket(reader, isFull);
    }

    public void setMaxHealth(int maxHealth) {
        super.setMaxHealth(maxHealth);
        if (this.scaling != null) {
            this.scaling.updatedMaxHealth();
        }
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, new NightDragonMobAI());
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.roar, (SoundEffect)SoundEffect.globalEffect().pitch(0.8f));
        }
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    public LootTable getPrivateLootTable() {
        return privateLootTable;
    }

    public boolean canBePushed(Mob other) {
        return false;
    }

    public GameDamage getCollisionDamage(Mob target, boolean fromPacket, ServerClient packetSubmitter) {
        return collisionDamage;
    }

    public int getCollisionKnockback(Mob target) {
        return 150;
    }

    public int getMaxHealth() {
        return super.getMaxHealth() + (int)((float)(this.scaling == null ? 0 : this.scaling.getHealthIncrease()) * this.getMaxHealthModifier());
    }

    public void setFacingDir(float deltaX, float deltaY) {
        if (deltaX < 0.0f) {
            this.setDir(0);
        } else if (deltaX > 0.0f) {
            this.setDir(1);
        }
    }

    public void clientTick() {
        super.clientTick();
        SoundManager.setMusic((GameMusic)MusicRegistry.AncientVulturesFeast, (SoundManager.MusicPriority)SoundManager.MusicPriority.EVENT, (float)1.5f);
        EventStatusBarManager.registerMobHealthStatusBar((Mob)this);
        BossNearbyBuff.applyAround((Mob)this);
        float healthPercInv = Math.abs((float)this.getHealth() / (float)this.getMaxHealth() - 1.0f);
        this.setSpeed(200.0f + healthPercInv * 120.0f);
    }

    public void serverTick() {
        super.serverTick();
        this.scaling.serverTick();
        BossNearbyBuff.applyAround((Mob)this);
        float healthPercInv = Math.abs((float)this.getHealth() / (float)this.getMaxHealth() - 1.0f);
        this.setSpeed(200.0f + healthPercInv * 120.0f);
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, i, 3, 112, this.x, this.y, 10.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 160;
        int drawY = camera.getDrawY(y) - 160 - FLY_HEIGHT;
        int dir = this.getDir();
        long time = level.getWorldEntity().getTime() % 350L;
        int sprite = time < 100L ? 0 : (time < 200L ? 1 : (time < 300L ? 2 : 3));
        float rotate = Math.min(10.0f, this.dx / 5.0f);
        TextureDrawOptionsEnd optionsLight = texture_light.initDraw().sprite(sprite, 0, 320).mirror(dir == 0, false).rotate(rotate, 160, 100).pos(drawX, drawY);
        TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite, 0, 320).light(light).mirror(dir == 0, false).rotate(rotate, 160, 100).pos(drawX, drawY);
        TextureDrawOptions shadowOptions = this.getShadowDrawOptions(x, y, light, camera);
        topList.add(arg_0 -> RejexBossMob.lambda$addDrawables$0(shadowOptions, (DrawOptions)options, (DrawOptions)optionsLight, arg_0));
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = texture_shadow;
        int drawX = camera.getDrawX(x) - shadowTexture.getWidth() / 2;
        int drawY = camera.getDrawY(y) - shadowTexture.getHeight() / 2 + 10;
        return shadowTexture.initDraw().light(light).pos(drawX, drawY);
    }

    public boolean shouldDrawOnMap() {
        return true;
    }

    public void drawOnMap(TickManager tickManager, Client client, int x, int y, double tileScale, Rectangle drawBounds, boolean isMinimap) {
        super.drawOnMap(tickManager, client, x, y, tileScale, drawBounds, isMinimap);
        GameTexture icon = texture_icon;
        int drawX = x - icon.getWidth() / 2;
        int drawY = y - icon.getHeight() / 2 - 16;
        int dir = this.getDir();
        icon.initDraw().mirror(dir == 0, false).draw(drawX, drawY);
    }

    public Rectangle drawOnMapBox(double tileScale, boolean isMinimap) {
        return new Rectangle(-21, -16, 40, 32);
    }

    public GameTooltips getMapTooltips() {
        return new StringTooltips(this.getDisplayName() + " " + this.getHealth() + "/" + this.getMaxHealth());
    }

    public Stream<ModifierValue<?>> getDefaultModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.SLOW, (Object)Float.valueOf(0.0f)).max((Object)Float.valueOf(0.2f)));
    }

    protected void onDeath(Attacker attacker, HashSet<Attacker> attackers) {
        super.onDeath(attacker, attackers);
        attackers.stream().map(Attacker::getFirstPlayerOwner).filter(Objects::nonNull).filter(PlayerMob::isServerClient).map(PlayerMob::getServerClient).distinct().forEach(c -> c.sendChatMessage((GameMessage)new LocalMessage("misc", "bossdefeat", "name", this.getLocalization())));
        if (!this.isDamagedByPlayers) {
            AchievementManager.checkMeAndThisArmyKill((Level)this.getLevel(), attackers);
        }
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadowOptions, DrawOptions options, DrawOptions optionsLight, TickManager tm) {
        shadowOptions.draw();
        options.draw();
        optionsLight.draw();
    }

    static {
        FLY_HEIGHT = 150;
    }

    public class NightDragonMobAI<T extends RejexBossMob>
    extends AINode<T> {
        private int removeCounter;
        private Mob currentTarget;
        private long findNewTargetTime;
        private final ArrayList<AttackRotation> attackRotations = new ArrayList();
        private int currentRotation;
        private final Point[] finalStage_positionRotation = new Point[]{new Point(128, 64), new Point(-128, -96), new Point(128, -64), new Point(-128, 96)};
        private int finalStage_currentPoint;
        private int finalStage_time = 0;

        public NightDragonMobAI() {
            this.attackRotations.add(new FlyAroundAttackRotation());
            this.attackRotations.add(new AttackPlayerRotation());
            this.attackRotations.add(new FlyAroundAttackRotation());
            this.attackRotations.add(new FireBarrageAttackRotation());
            this.attackRotations.add(new AttackPlayerRotation());
            this.currentRotation = 0;
        }

        protected void onRootSet(AINode<T> root, T mob, Blackboard<T> blackboard) {
            blackboard.onEvent("refreshBossDespawn", event -> {
                this.removeCounter = 0;
            });
            if (mob.isServer()) {
                this.attackRotations.get(this.currentRotation).start();
            }
        }

        public void init(T mob, Blackboard<T> blackboard) {
        }

        public AINodeResult tick(T mob, Blackboard<T> blackboard) {
            this.tickTargets();
            if (this.currentTarget != null) {
                this.removeCounter = 0;
                if (this.finalStage_time > 0 || mob.getHealthPercent() < 0.1f) {
                    this.finalStage_time += 50;
                    if (RejexBossMob.this.hasArrivedAtTarget()) {
                        this.finalStage_currentPoint = (this.finalStage_currentPoint + 1) % this.finalStage_positionRotation.length;
                    }
                    if (this.finalStage_time % 150 == 0) {
                        this.shotFire((RejexBossMob)((Object)mob), null, 300, 15.0f, 0.0f, projectileDamage);
                    }
                    Point point = this.finalStage_positionRotation[this.finalStage_currentPoint];
                    RejexBossMob.this.setMovement((MobMovement)new MobMovementRelative(this.currentTarget, (float)point.x, (float)point.y));
                } else {
                    if (this.attackRotations.get(this.currentRotation).isOver()) {
                        this.currentRotation = (this.currentRotation + 1) % this.attackRotations.size();
                        this.attackRotations.get(this.currentRotation).start();
                    }
                    this.attackRotations.get(this.currentRotation).tick();
                }
            } else {
                RejexBossMob.this.stopMoving();
                ++this.removeCounter;
                if (this.removeCounter > 100) {
                    RejexBossMob.this.remove();
                }
            }
            return AINodeResult.SUCCESS;
        }

        public void tickTargets() {
            if (this.currentTarget != null) {
                if (this.currentTarget.isSamePlace((Entity)this.mob()) && !this.currentTarget.removed()) {
                    if (RejexBossMob.this.getWorldEntity().getTime() <= this.findNewTargetTime) {
                        this.refreshTarget();
                    }
                } else {
                    this.refreshTarget();
                }
            } else {
                this.refreshTarget();
            }
        }

        public void refreshTarget() {
            this.currentTarget = GameUtils.streamServerClients((Level)RejexBossMob.this.getLevel()).map(c -> c.playerMob).min(Comparator.comparingInt(player -> (int)RejexBossMob.this.getDistance((Mob)player))).orElse(null);
            this.findNewTargetTime = RejexBossMob.this.getWorldEntity().getTime() + 5000L;
        }

        private void shotFire(RejexBossMob rejexMob, Mob target, int speed, float maxOffset, float prediction, GameDamage damage) {
            int distance;
            float angle;
            if (target == null) {
                angle = GameRandom.globalRandom.getFloatBetween(0.0f, 360.0f);
                distance = GameRandom.globalRandom.getIntBetween(8, 256);
            } else {
                float targetPredictedX = target.x;
                float targetPredictedY = target.y;
                if (prediction > 0.0f) {
                    float targetDistance = rejexMob.getDistance(target);
                    float time = targetDistance / (float)speed;
                    targetPredictedX += target.dx * time * prediction;
                    targetPredictedY += target.dy * time * prediction;
                }
                angle = (float)Math.toDegrees(Math.atan2(targetPredictedY - rejexMob.y, targetPredictedX - rejexMob.x));
                distance = (int)((float)target.getFlyingHeight() + rejexMob.getDistance(targetPredictedX, targetPredictedY) + (float)GameRandom.globalRandom.getIntBetween(40, 120));
            }
            if (maxOffset != 0.0f) {
                angle = GameRandom.globalRandom.getFloatOffset(angle, maxOffset);
            }
            float targetX = rejexMob.x + GameMath.cos((float)angle) * 100.0f;
            float targetY = rejexMob.y + GameMath.sin((float)angle) * 100.0f;
            RejexFireProjectile projectile = new RejexFireProjectile(rejexMob.x, rejexMob.y, targetX, targetY, speed, distance, damage, (Mob)rejexMob);
            rejexMob.getLevel().entityManager.projectiles.add((Entity)projectile);
        }

        private Mob getClosestTarget(RejexBossMob rejexMob) {
            return this.getAllTargets(rejexMob).stream().min((m1, m2) -> (int)(m1.getDistance((Mob)rejexMob) - m2.getDistance((Mob)rejexMob))).orElse(null);
        }

        private List<Mob> getAllTargets(RejexBossMob rejexMob) {
            return (List)rejexMob.getLevel().entityManager.streamAreaMobsAndPlayers(rejexMob.x, rejexMob.y, 2048).filter(m -> {
                if (!m.canBeTargeted((Mob)rejexMob, null)) {
                    return false;
                }
                if (m != rejexMob && !m.removed() && m.isVisible()) {
                    int team = m.getTeam();
                    if (team == -100) {
                        return true;
                    }
                    return m.isHuman && team != -1 || m.isPlayer;
                }
                return false;
            }).collect(Collectors.toList());
        }

        private class FlyAroundAttackRotation
        extends AttackRotation {
            private final Point[] positionRotation;
            private int currentPoint;
            private int timer;

            private FlyAroundAttackRotation() {
                this.positionRotation = new Point[]{new Point(260, 260), new Point(-260, -180), new Point(260, -260), new Point(-260, 180)};
            }

            @Override
            public void start() {
                this.timer = 0;
            }

            @Override
            public void tick() {
                this.timer += 50;
                if (RejexBossMob.this.hasArrivedAtTarget()) {
                    this.currentPoint = (this.currentPoint + 1) % this.positionRotation.length;
                    float healthPerc = (float)RejexBossMob.this.getHealth() / (float)RejexBossMob.this.getMaxHealth();
                    NightDragonMobAI.this.shotFire(RejexBossMob.this, NightDragonMobAI.this.getClosestTarget(RejexBossMob.this), (int)(250.0f - healthPerc * 100.0f), 5.0f, 0.6f, projectileDamage);
                }
                Point point = this.positionRotation[this.currentPoint];
                RejexBossMob.this.setMovement((MobMovement)new MobMovementRelative(NightDragonMobAI.this.currentTarget, (float)point.x, (float)point.y));
            }

            @Override
            public boolean isOver() {
                float healthPerc = (float)RejexBossMob.this.getHealth() / (float)RejexBossMob.this.getMaxHealth();
                return (float)this.timer > 500.0f * (5.0f + healthPerc * 10.0f);
            }
        }

        private class AttackPlayerRotation
        extends AttackRotation {
            private int timer;

            private AttackPlayerRotation() {
            }

            @Override
            public void start() {
                this.timer = 0;
            }

            @Override
            public void tick() {
                this.timer += 50;
                RejexBossMob.this.setMovement((MobMovement)new MobMovementRelative(NightDragonMobAI.this.currentTarget, 0.0f, 0.0f));
            }

            @Override
            public boolean isOver() {
                float healthPerc = (float)RejexBossMob.this.getHealth() / (float)RejexBossMob.this.getMaxHealth();
                return (float)this.timer > 1000.0f * (2.0f - healthPerc);
            }
        }

        private class FireBarrageAttackRotation
        extends AttackRotation {
            private int timer;

            private FireBarrageAttackRotation() {
            }

            @Override
            public void start() {
                this.timer = 0;
            }

            @Override
            public void tick() {
                this.timer += 50;
                if (this.timer % 300 == 0) {
                    float healthPerc = (float)RejexBossMob.this.getHealth() / (float)RejexBossMob.this.getMaxHealth();
                    NightDragonMobAI.this.shotFire(RejexBossMob.this, NightDragonMobAI.this.getClosestTarget(RejexBossMob.this), (int)((float)GameRandom.globalRandom.getIntBetween(250, 300) - healthPerc * 100.0f), 15.0f, 1.0f, projectileDamage);
                }
            }

            @Override
            public boolean isOver() {
                float healthPerc = (float)RejexBossMob.this.getHealth() / (float)RejexBossMob.this.getMaxHealth();
                return (float)this.timer > 10000.0f - 5000.0f * healthPerc;
            }
        }

        private abstract class AttackRotation {
            private AttackRotation() {
            }

            public abstract void start();

            public abstract void tick();

            public abstract boolean isOver();
        }
    }
}

