/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.mobs;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.DifficultyBasedGetter;
import necesse.engine.eventStatusBars.EventStatusBarManager;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.MaxHealthGetter;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MobHealthScaling;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.ConfusedCollisionPlayerChaserWandererAI;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.hostile.HostileMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.LootItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class DarkPaladinMob
extends HostileMob {
    public static GameTexture texture_icon;
    public static LootTable lootTable;
    protected MobHealthScaling scaling = new MobHealthScaling((Mob)this);
    public static MaxHealthGetter MAX_HEALTH;

    public DarkPaladinMob() {
        super(100);
        this.difficultyChanges.setMaxHealth((DifficultyBasedGetter)MAX_HEALTH);
        this.setSpeed(20.0f);
        this.setFriction(5.0f);
        this.setKnockbackModifier(0.0f);
        this.setArmor(10);
        this.moveAccuracy = 2;
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle(-14, -41, 28, 48);
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
    }

    public void setupHealthPacket(PacketWriter writer, boolean isFull) {
        this.scaling.setupHealthPacket(writer, isFull);
        super.setupHealthPacket(writer, isFull);
    }

    public void applyHealthPacket(PacketReader reader, boolean isFull) {
        this.scaling.applyHealthPacket(reader, isFull);
        super.applyHealthPacket(reader, isFull);
    }

    public void setMaxHealth(int maxHealth) {
        super.setMaxHealth(maxHealth);
        if (this.scaling != null) {
            this.scaling.updatedMaxHealth();
        }
    }

    public int getMaxHealth() {
        return super.getMaxHealth() + (int)((float)(this.scaling == null ? 0 : this.scaling.getHealthIncrease()) * this.getMaxHealthModifier());
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new ConfusedCollisionPlayerChaserWandererAI<DarkPaladinMob>(null, 512, new GameDamage(35.0f, this.getLevel().getIslandDimension() == -2 ? 100.0f : 10.0f), 100, 40000){

            public boolean attackTarget(DarkPaladinMob mob, Mob target) {
                boolean success = super.attackTarget((Mob)mob, target);
                if (success) {
                    target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.STUNNED_DAMAGE_TAKEN_INCREASED, target, 0.2f, null), mob.isServer());
                    target.buffManager.addBuff(new ActiveBuff(DarkPaladinMob.this.getLevel().getIslandDimension() == -2 ? BuffRegistry.Debuffs.ABLAZE : BuffRegistry.Debuffs.ON_FIRE, target, 5.0f, null), mob.isServer());
                    target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.NECROTIC_SLOW, target, 3.0f, null), mob.isServer());
                }
                return success;
            }
        });
    }

    public void clientTick() {
        super.clientTick();
        EventStatusBarManager.registerMobHealthStatusBar((Mob)this);
        float healthPercInv = Math.abs((float)this.getHealth() / (float)this.getMaxHealth() - 1.0f);
        this.setSpeed((this.getLevel().getIslandDimension() == -2 ? 1.5f : 1.0f) * (20.0f + healthPercInv * 60.0f));
    }

    public void serverTick() {
        super.serverTick();
        this.scaling.serverTick();
        float healthPercInv = Math.abs((float)this.getHealth() / (float)this.getMaxHealth() - 1.0f);
        this.setSpeed((this.getLevel().getIslandDimension() == -2 ? 1.5f : 1.0f) * (20.0f + healthPercInv * 60.0f));
    }

    public boolean shouldDrawOnMap() {
        return true;
    }

    public void drawOnMap(TickManager tickManager, Client client, int x, int y, double tileScale, Rectangle drawBounds, boolean isMinimap) {
        super.drawOnMap(tickManager, client, x, y, tileScale, drawBounds, isMinimap);
        GameTexture icon = texture_icon;
        int drawX = x - icon.getWidth() / 2;
        int drawY = y - icon.getHeight() / 2 - 16;
        int dir = this.getDir();
        icon.initDraw().mirror(dir == 0, false).draw(drawX, drawY);
    }

    public Rectangle drawOnMapBox(double tileScale, boolean isMinimap) {
        return new Rectangle(-21, -16, 40, 32);
    }

    public GameTooltips getMapTooltips() {
        return new StringTooltips(this.getDisplayName() + " " + this.getHealth() + "/" + this.getMaxHealth());
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, MobRegistry.Textures.ancientArmoredSkeleton).sprite(sprite).dir(dir).mask(swimMask).light(light);
        final DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable(){

            public void draw(TickManager tickManager) {
                drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public int getRockSpeed() {
        return 20;
    }

    static {
        lootTable = new LootTable(new LootItemInterface[]{new LootItem("paladinsjewel")});
        MAX_HEALTH = new MaxHealthGetter(800, 1000, 1200, 1400, 1600);
    }
}

