/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.levelevents;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.mobAbilityLevelEvent.GroundEffectEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobHitCooldowns;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class SwordStormEvent
extends GroundEffectEvent {
    protected MobHitCooldowns hitCooldowns = new MobHitCooldowns(200);
    protected int tickCounter;
    protected SwordStormParticle particle;
    private GameDamage damage;
    private float resilienceGain;

    public SwordStormEvent(Mob owner, int x, int y, GameRandom uniqueIDRandom, GameDamage damage, float resilienceGain) {
        super(owner, x, y, uniqueIDRandom);
        this.damage = damage;
        this.resilienceGain = resilienceGain;
    }

    public SwordStormEvent() {
    }

    public void init() {
        super.init();
        this.tickCounter = 0;
        if (this.isClient()) {
            this.particle = new SwordStormParticle(this.level, this.x, this.y, 5000L, this.owner);
            this.level.entityManager.addParticle((Particle)this.particle, Particle.GType.CRITICAL);
        }
    }

    public Shape getHitBox() {
        int width = 256;
        int height = 256;
        return new Rectangle(this.x - width / 2, this.y - height / 2, width, height);
    }

    public void clientHit(Mob target) {
        this.hitCooldowns.startCooldown(target);
    }

    public void serverHit(Mob target, boolean clientSubmitted) {
        if (clientSubmitted || this.hitCooldowns.canHit(target)) {
            target.isServerHit(this.damage, (float)this.x, (float)this.y, 10.0f, (Attacker)this.owner);
            this.hitCooldowns.startCooldown(target);
            if (target.canGiveResilience((Attacker)this.owner) && this.resilienceGain != 0.0f) {
                this.owner.addResilience(this.resilienceGain);
                this.resilienceGain = 0.0f;
            }
        }
    }

    public void hitObject(LevelObjectHit var1) {
    }

    public boolean canHit(Mob mob) {
        return super.canHit(mob) && this.hitCooldowns.canHit(mob);
    }

    public void clientTick() {
        ++this.tickCounter;
        this.x = (int)(this.owner.x + this.owner.dx * 0.1f);
        this.y = (int)(this.owner.y + this.owner.dx * 0.1f);
        if (this.tickCounter > 100) {
            this.particle.remove();
            this.over();
        } else {
            super.clientTick();
        }
    }

    public void serverTick() {
        ++this.tickCounter;
        this.x = (int)(this.owner.x + this.owner.dx * 0.1f);
        this.y = (int)(this.owner.y + this.owner.dx * 0.1f);
        if (this.tickCounter > 100) {
            this.over();
        } else {
            super.serverTick();
        }
    }

    public static class SwordStormParticle
    extends Particle {
        public static GameTexture texture;
        protected Mob owner;

        public SwordStormParticle(Level level, float x, float y, long lifeTime, Mob owner) {
            super(level, x, y, lifeTime);
            this.owner = owner;
        }

        public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            GameLight light = level.getLightLevel(this.getX() / 32, this.getY() / 32);
            int drawX = camera.getDrawX(this.x) - texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y) - texture.getHeight() / 2;
            float life = this.getLifeCycleTime();
            TextureDrawOptionsEnd options = texture.initDraw().light(light).rotate(life, texture.getWidth() / 2, texture.getHeight() / 2).pos(drawX, drawY);
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
        }

        public void clientTick() {
            super.clientTick();
            this.x = (int)(this.owner.x + this.owner.dx * 0.1f);
            this.y = (int)(this.owner.y + this.owner.dx * 0.1f);
        }
    }
}

