/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.items.weapons.range.gun;

import java.awt.Point;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import scorchedbiome.projectiles.modifiers.OnFireProjectileModifier;

public class DraconicShottyToolItem
extends GunProjectileToolItem {
    public DraconicShottyToolItem() {
        super(NORMAL_AMMO_TYPES, 400, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.UNCOMMON;
        this.attackAnimTime.setBaseValue(950);
        this.attackDamage.setBaseValue(25.0f).setUpgradedValue(1.0f, 52.0f);
        this.attackXOffset = 18;
        this.attackYOffset = 20;
        this.attackRange.setBaseValue(750);
        this.velocity.setBaseValue(350);
        this.moveDist = 20;
        this.resilienceGain.setBaseValue(0.3f);
        this.addGlobalIngredient(new String[]{"bulletuser"});
        this.canBeUsedForRaids = true;
        this.useForRaidsOnlyIfObtained = true;
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        super.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"draconicShottyEffect"), 400);
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        super.setDrawAttackRotation(item, drawOptions, attackDirX, attackDirY, attackProgress);
        drawOptions.addedArmPosOffset(-3, 5);
    }

    public Projectile getProjectile(InventoryItem item, BulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        return super.getProjectile(item, bulletItem, x, y + 12.0f, targetX, targetY + 12.0f, range, attackerMob);
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(spreadRandom, (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        for (int i = 0; i <= 3; ++i) {
            Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
            projectile.setModifier((ProjectileModifier)new OnFireProjectileModifier(20.0f + this.getUpgradeTier(item) * 2.0f, this.getResilienceGain(item)));
            projectile.dropItem = dropItem;
            projectile.getUniqueID(random);
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist, (spreadRandom.nextFloat() - 0.5f) * 20.0f);
        }
    }

    public void playFireSound(AttackAnimMob mob) {
        SoundManager.playSound((GameSound)GameResources.shotgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob));
    }
}

