/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.items.weapons.range.greatbow;

import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.arrowItem.ArrowItem;
import necesse.inventory.item.toolItem.projectileToolItem.bowProjectileToolItem.greatbowProjectileToolItem.GreatbowProjectileToolItem;
import necesse.inventory.lootTable.presets.GreatbowWeaponsLootTable;
import necesse.level.maps.Level;
import scorchedbiome.projectiles.modifiers.OnFireProjectileModifier;

public class DraconicGreatbowToolItem
extends GreatbowProjectileToolItem {
    public DraconicGreatbowToolItem() {
        super(400, GreatbowWeaponsLootTable.greatbowWeapons);
        this.attackAnimTime.setBaseValue(600);
        this.rarity = Item.Rarity.UNCOMMON;
        this.attackDamage.setBaseValue(115.0f).setUpgradedValue(1.0f, 118.0f);
        this.velocity.setBaseValue(500);
        this.attackRange.setBaseValue(800);
        this.attackXOffset = 12;
        this.attackYOffset = 38;
        this.particleColor = new Color(120, 30, 30);
        this.canBeUsedForRaids = true;
        this.raidTicketsModifier = 0.25f;
        this.useForRaidsOnlyIfObtained = true;
    }

    protected void addExtraBowTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        super.addExtraBowTooltips(tooltips, item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"draconicbowtip"));
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, ArrowItem arrow, boolean dropItem, GNDItemMap mapContent) {
        Projectile projectile = this.getProjectile(level, x, y, attackerMob, item, seed, arrow, dropItem, mapContent);
        float percentCharge = item.getGndData().getFloat("chargePercent");
        percentCharge = GameMath.limit((float)percentCharge, (float)0.0f, (float)1.0f);
        projectile.setModifier((ProjectileModifier)new OnFireProjectileModifier(percentCharge * 100.0f / 2.0f, this.getResilienceGain(item)));
        projectile.dropItem = dropItem;
        projectile.getUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
    }
}

