/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.items.weapons.melee.sword;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.toolItem.swordToolItem.SwordToolItem;
import necesse.inventory.lootTable.presets.CloseRangeWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;
import scorchedbiome.levelevents.SwordStormEvent;
import scorchedbiome.registry.SchBuffs;

public class DraconicSwordToolItem
extends SwordToolItem
implements ItemInteractAction {
    public DraconicSwordToolItem() {
        super(1200, CloseRangeWeaponsLootTable.closeRangeWeapons);
        this.rarity = Item.Rarity.UNCOMMON;
        this.attackAnimTime.setBaseValue(355);
        this.attackDamage.setBaseValue(88.0f).setUpgradedValue(1.0f, 90.0f);
        this.attackRange.setBaseValue(155);
        this.knockback.setBaseValue(100);
        this.canBeUsedForRaids = true;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return !attackerMob.buffManager.hasBuff(SchBuffs.SWORD_STORM_COOLDOWN);
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        SwordStormEvent event = new SwordStormEvent((Mob)attackerMob, (int)attackerMob.x, (int)attackerMob.y, GameRandom.globalRandom, this.getAttackDamage(item).modDamage(0.2f), this.getResilienceGain(item));
        level.entityManager.addLevelEvent((LevelEvent)event);
        attackerMob.buffManager.addBuff(new ActiveBuff(SchBuffs.SWORD_STORM_ACTIVE, (Mob)attackerMob, 5.0f, null), attackerMob.isServer());
        attackerMob.buffManager.addBuff(new ActiveBuff(SchBuffs.SWORD_STORM_COOLDOWN, (Mob)attackerMob, 10.0f, null), attackerMob.isServer());
        return item;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"draconicswordtip"));
        return tooltips;
    }
}

