/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.items.weapons.magic;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.inventory.lootTable.presets.MagicWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;

public class DraconicStaffToolItem
extends MagicProjectileToolItem {
    public DraconicStaffToolItem() {
        super(400, MagicWeaponsLootTable.magicWeapons);
        this.rarity = Item.Rarity.UNCOMMON;
        this.attackAnimTime.setBaseValue(300);
        this.attackDamage.setBaseValue(12.0f).setUpgradedValue(1.0f, 35.0f);
        this.velocity.setBaseValue(100);
        this.attackXOffset = 20;
        this.attackYOffset = 30;
        this.attackRange.setBaseValue(1250);
        this.knockback.setBaseValue(15);
        this.manaCost.setBaseValue(3.5f).setUpgradedValue(1.0f, 3.2f);
        this.resilienceGain.setBaseValue(0.5f);
        this.itemAttackerProjectileCanHitWidth = 5.0f;
        this.itemAttackerPredictionDistanceOffset = -20.0f;
        this.canBeUsedForRaids = true;
        this.minRaidTier = 1;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"draconicstafftip"));
        return tooltips;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.3f).pitch(GameRandom.globalRandom.getFloatBetween(1.5f, 1.6f)));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        GameRandom random = new GameRandom((long)seed);
        for (int i = -1; i <= 1; ++i) {
            Projectile slimeBoltProjectile = ProjectileRegistry.getProjectile((String)"DraconicStaffFireball", (Level)level, (float)attackerMob.x, (float)attackerMob.y, (float)x, (float)y, (float)this.getProjectileVelocity(item, (Mob)attackerMob), (int)this.getAttackRange(item), (GameDamage)this.getAttackDamage(item), (int)this.getKnockback(item, (Attacker)attackerMob), (Mob)attackerMob);
            slimeBoltProjectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            slimeBoltProjectile.resetUniqueID(random);
            attackerMob.addAndSendAttackerProjectile(slimeBoltProjectile, 20, (float)(10 * i));
        }
        this.consumeMana(attackerMob, item);
        return item;
    }
}

