/*
 * Decompiled with CFR 0.152.
 */
package scorchedbiome.biomes;

import java.awt.Color;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import necesse.engine.AbstractMusicList;
import necesse.engine.MusicList;
import necesse.engine.registries.MusicRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.engine.sound.GameMusic;
import necesse.engine.util.GameRandom;
import necesse.engine.util.TicketSystemList;
import necesse.engine.world.biomeGenerator.BiomeGeneratorStack;
import necesse.entity.mobs.PlayerMob;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.biomes.FishingLootTable;
import necesse.level.maps.biomes.FishingSpot;
import necesse.level.maps.biomes.MobSpawnTable;
import necesse.level.maps.biomes.forest.ForestBiome;
import necesse.level.maps.presets.RandomCaveChestRoom;
import necesse.level.maps.presets.caveRooms.CaveRuins;
import necesse.level.maps.presets.set.ChestRoomSet;
import necesse.level.maps.presets.set.FurnitureSet;
import necesse.level.maps.presets.set.VillageSet;
import necesse.level.maps.presets.set.WallSet;
import necesse.level.maps.regionSystem.Region;
import scorchedbiome.registry.SchLootTables;
import scorchedbiome.registry.SchObjects;
import scorchedbiome.registry.SchTiles;
import scorchedbiome.registry.sets.SchChestRoomSets;
import scorchedbiome.registry.sets.SchVillageSets;
import scorchedbiome.registry.sets.SchWallSets;

public class ScorchedBiome
extends Biome {
    public static MobSpawnTable caveMobs;
    public static MobSpawnTable deepCaveMobs;
    public static MobSpawnTable caveCritters;
    public static MobSpawnTable deepCaveCritters;

    public float getWindModifier(Level level, int tileX, int tileY) {
        return level.isCave ? 0.1f : super.getWindModifier(level, tileX, tileY);
    }

    public Color getWindColor(Level level) {
        return new Color(204, 153, 153);
    }

    public MobSpawnTable getCritterSpawnTable(Level level) {
        if (level.isCave) {
            return level.getIslandDimension() == -2 ? deepCaveCritters : caveCritters;
        }
        return super.getCritterSpawnTable(level);
    }

    public MobSpawnTable getMobSpawnTable(Level level) {
        if (!level.isCave) {
            return defaultSurfaceMobs;
        }
        return level.getIslandDimension() == -2 ? deepCaveMobs : caveMobs;
    }

    public FishingLootTable getFishingLootTable(FishingSpot spot) {
        return !spot.tile.level.isCave ? ForestBiome.forestSurfaceFish : super.getFishingLootTable(spot);
    }

    public AbstractMusicList getLevelMusic(Level level, PlayerMob perspective) {
        if (level.isCave) {
            return level.getIslandDimension() == -2 ? new MusicList(new GameMusic[]{MusicRegistry.ForgottenDepths}) : new MusicList(new GameMusic[]{MusicRegistry.RunecarvedWalls});
        }
        return level.getWorldEntity().isNight() ? new MusicList(new GameMusic[]{MusicRegistry.FieldsOfSerenity}) : new MusicList(new GameMusic[]{MusicRegistry.SwampCavern});
    }

    public RandomCaveChestRoom getNewCaveChestRoomPreset(GameRandom random, AtomicInteger lootRotation) {
        return new RandomCaveChestRoom(random, SchLootTables.scorchedCaveTreasure, lootRotation, new ChestRoomSet[]{SchChestRoomSets.scorched, SchChestRoomSets.scorchedStone});
    }

    public RandomCaveChestRoom getNewDeepCaveChestRoomPreset(GameRandom random, AtomicInteger lootRotation) {
        RandomCaveChestRoom chestRoom = new RandomCaveChestRoom(random, SchLootTables.scorchedDeepCaveTreasure, lootRotation, new ChestRoomSet[]{ChestRoomSet.deepStone, SchChestRoomSets.scorchedDeepStone});
        chestRoom.replaceTile(TileRegistry.deepStoneFloorID, ((Integer)random.getOneOf((Object[])new Integer[]{TileRegistry.deepStoneFloorID, TileRegistry.deepStoneBrickFloorID})).intValue());
        return chestRoom;
    }

    public CaveRuins getNewCaveRuinsPreset(GameRandom random, AtomicInteger lootRotation) {
        WallSet wallSet = (WallSet)random.getOneOf((Object[])new WallSet[]{SchWallSets.scorchedStone, SchWallSets.scorched});
        FurnitureSet furnitureSet = (FurnitureSet)random.getOneOf((Object[])new FurnitureSet[]{FurnitureSet.pine, FurnitureSet.maple});
        String floorStringID = (String)random.getOneOf((Object[])new String[]{"scorchedwoodfloortile", "scorchedstonebrickfloortile"});
        return ((CaveRuins.CaveRuinGetter)random.getOneOf((List)CaveRuins.caveRuinGetters)).get(random, wallSet, furnitureSet, floorStringID, SchLootTables.scorchedCaveRuinsChest, lootRotation);
    }

    public CaveRuins getNewDeepCaveRuinsPreset(GameRandom random, AtomicInteger lootRotation) {
        WallSet wallSet = (WallSet)random.getOneOf((Object[])new WallSet[]{WallSet.obsidian, SchWallSets.scorchedDeepStone});
        FurnitureSet furnitureSet = (FurnitureSet)random.getOneOf((Object[])new FurnitureSet[]{FurnitureSet.dungeon});
        String floorStringID = (String)random.getOneOf((Object[])new String[]{"scorchedwoodfloortile", "scorchedstonebrickfloortile"});
        return ((CaveRuins.CaveRuinGetter)random.getOneOf((List)CaveRuins.caveRuinGetters)).get(random, wallSet, furnitureSet, floorStringID, SchLootTables.scorchedDeepCaveRuinsChest, lootRotation);
    }

    public int getGenerationTerrainTileID() {
        return SchTiles.scorchedGrassID;
    }

    public int getGenerationCaveTileID() {
        return SchTiles.scorchedRockID;
    }

    public int getGenerationCaveRockObjectID() {
        return SchObjects.scorchedRockId;
    }

    public int getGenerationDeepCaveTileID() {
        return SchTiles.scorchedDeepRockID;
    }

    public int getGenerationDeepCaveRockObjectID() {
        return SchObjects.scorchedDeepRockId;
    }

    public VillageSet[] getVillageSets() {
        return new VillageSet[]{SchVillageSets.scorched};
    }

    public void initializeGeneratorStack(BiomeGeneratorStack stack) {
        super.initializeGeneratorStack(stack);
        stack.addRandomSimplexVeinsBranch("scorchedOvergrownGrass", 2.5f, 0.45f, 0.7f, 2);
        stack.addRandomSimplexVeinsBranch("scorchedTrees", 2.0f, 0.2f, 1.0f, 0);
        stack.addRandomVeinsBranch("scorchedSheep", 0.035f, 8, 12, 0.1f, 0, false);
        stack.addRandomVeinsBranch("scorchedWhiteFlowerPatch", 0.05f, 5, 15, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedCopper", 0.48f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedIron", 0.4f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedGold", 0.24f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedLavanite", 0.18f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedDeepCopper", 0.08f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedDeepIron", 0.4f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedDeepGold", 0.24f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedDeepObsidian", 0.4f, 5, 10, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedDeepTungsten", 0.08f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedDeepLifeQuartz", 0.08f, 3, 6, 0.4f, 2, false);
        stack.addRandomVeinsBranch("scorchedDeepAsh", 0.16f, 2, 3, 0.4f, 2, false);
    }

    public void generateRegionSurfaceTerrain(Region region, BiomeGeneratorStack stack, GameRandom random) {
        super.generateRegionSurfaceTerrain(region, stack, random);
        int scorchedTile = SchTiles.scorchedGrassID;
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedTrees").onlyOnTile(scorchedTile).chance((double)0.03f).placeObject("scorchedtree");
        stack.startPlace((Biome)this, region, random).chance((double)0.24f).onlyOnTile(scorchedTile).placeObject("scorchedgrass");
        stack.startPlace((Biome)this, region, random).chance((double)0.0015f).placeObject("surfacerock");
        stack.startPlace((Biome)this, region, random).chance((double)0.0025f).placeObject("surfacerocksmall");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedWhiteFlowerPatch").onlyOnTile(scorchedTile).chance((double)0.4f).placeObject("whiteflowerpatch");
        TicketSystemList sheepSpawns = new TicketSystemList().addObject(100, (Object)"sheep").addObject(25, (Object)"ram");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedSheep").onlyOnTile(scorchedTile).placeMob(sheepSpawns);
    }

    public void generateRegionCaveTerrain(Region region, BiomeGeneratorStack stack, GameRandom random) {
        super.generateRegionCaveTerrain(region, stack, random);
        stack.startPlace((Biome)this, region, random).chance((double)0.01f).placeObject("scorchedcaverocksmall");
        stack.startPlace((Biome)this, region, random).chance((double)0.03f).placeCrates(new String[]{"scorchedcrate", "vase"});
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedLavanite").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("lavaniteoreobject");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedCopper").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("copperorescorchedstone");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedIron").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("ironorescorchedstone");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedGold").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("goldorescorchedstone");
    }

    public void generateRegionDeepCaveTerrain(Region region, BiomeGeneratorStack stack, GameRandom random) {
        super.generateRegionDeepCaveTerrain(region, stack, random);
        stack.startPlace((Biome)this, region, random).chance((double)0.01f).placeObject("scorcheddeepcaverocksmall");
        stack.startPlace((Biome)this, region, random).chance((double)0.03f).placeCrates(new String[]{"scorchedcrate", "vase"});
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedDeepCopper").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("copperoredeepscorchedstone");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedDeepIron").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("ironoredeepscorchedstone");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedDeepGold").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("goldoredeepscorchedstone");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedDeepObsidian").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("obsidianrock");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedDeepTungsten").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("tungstenoredeepscorchedstone");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedDeepLifeQuartz").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("lifequartzdeepscorchedstone");
        stack.startPlaceOnVein((Biome)this, region, random, "scorchedDeepAsh").onlyOnObject(SchObjects.scorchedRockId).placeObjectForced("scorchedashrock");
    }

    public Color getDebugBiomeColor() {
        return new Color(153, 153, 153);
    }

    static {
        caveCritters = new MobSpawnTable().add(5, "scorchedcaveling");
        deepCaveCritters = new MobSpawnTable().add(5, "scorchedcaveling");
        caveMobs = new MobSpawnTable().add(100, "zombie").add(100, "zombiearcher").add(25, "cavemole").add(3, "darkpaladin");
        deepCaveMobs = new MobSpawnTable().add(100, "skeleton").add(100, "skeletonthrower").add(5, "darkpaladin");
    }
}

