/*
 * Decompiled with CFR 0.152.
 */
package NecesseExpanded.Utils.RaiderWeapons;

import NecesseExpanded.Projectiles.RaiderBombProjectile;
import java.awt.Point;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.throwToolItem.SettlerIgnoredThrowToolItem;
import necesse.level.maps.Level;

public class RaiderBomb
extends SettlerIgnoredThrowToolItem {
    public RaiderBomb() {
        this.stackSize = 100;
        this.attackAnimTime.setBaseValue(1000);
        this.attackRange.setBaseValue(600);
        this.attackDamage.setBaseValue(0.0f);
        this.velocity.setBaseValue(100);
        this.rarity = Item.Rarity.COMMON;
        this.resilienceGain.setBaseValue(0.0f);
    }

    public GameMessage getItemAttackerCanUseError(ItemAttackerMob mob, InventoryItem item) {
        return new LocalMessage("ui", "settlercantuseitem");
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"destructivetip"));
        return tooltips;
    }

    public Point getControllerAttackLevelPos(Level level, float aimDirX, float aimDirY, PlayerMob player, InventoryItem item) {
        int range = this.getAttackRange(item);
        return new Point((int)(player.x + aimDirX * (float)range), (int)(player.y + aimDirY * (float)range));
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        GameRandom random = new GameRandom((long)seed);
        Point targetPos = this.controlledRangePosition(random, (Mob)attackerMob, x, y, item, 0, 40);
        int newRange = (int)attackerMob.getDistance((float)targetPos.x, (float)targetPos.y);
        RaiderBombProjectile projectile = new RaiderBombProjectile(attackerMob.x, attackerMob.y, targetPos.x, targetPos.y, this.getThrowingVelocity(item, (Mob)attackerMob), newRange, new GameDamage(20.0f), (Mob)attackerMob);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        projectile.setLevel(level);
        projectile.resetUniqueID(random);
        attackerMob.addAndSendAttackerProjectile((Projectile)projectile);
        item.setAmount(item.getAmount() - 1);
        return item;
    }
}

