/*
 * Decompiled with CFR 0.152.
 */
package NecesseExpanded.Patches.Raids;

import NecesseExpanded.Events.Raids.AncientSkeletonRaid;
import NecesseExpanded.Events.Raids.GraveyardRaid;
import NecesseExpanded.Events.Raids.NinjaRaid;
import NecesseExpanded.Events.Raids.PirateRaid;
import NecesseExpanded.Events.Raids.RuneboundRaid;
import NecesseExpanded.Events.Raids.SkeletonRaid;
import NecesseExpanded.Events.Raids.SlimeCaveRaid;
import NecesseExpanded.Events.Raids.SpiderkinRaid;
import NecesseExpanded.Events.Raids.ZombieRaid;
import NecesseExpanded.Main;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.settlementRaidEvent.AncientSkeletonRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.BasicSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.ChickenPeopleSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.FishianSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.FrozenDwarvesSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.HumanSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.MummiesSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.NinjaSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.PiratesSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.RogueHuntersSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.SettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.TheMafiaRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.VampiresSettlementRaidLevelEvent;
import necesse.entity.levelEvent.settlementRaidEvent.VoidApprenticesSettlementRaidLevelEvent;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.SettlementRaidOptions;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=ServerSettlementData.class, name="getNextRaid", arguments={SettlementRaidOptions.class})
public class RaidConfiguration {
    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    static boolean onEnter() {
        return Main.SettingsGetter.getBoolean("raids_enabled");
    }

    @Advice.OnMethodExit
    static void onExit(@Advice.This ServerSettlementData LevelData, @Advice.Argument(value=0) SettlementRaidOptions Options, @Advice.Return(readOnly=false) SettlementRaidLevelEvent Event) {
        if (Main.SettingsGetter.getBoolean("raids_enabled") && Main.SettingsGetter.getBoolean("include_vanilla_raids")) {
            Event = GameRandom.globalRandom.getChance((float)Main.SettingsGetter.getInt("vanilla_raid_chance") / 100.0f) ? (LevelData.hasCompletedQuestTier("pestwarden") ? (SettlementRaidLevelEvent)GameRandom.globalRandom.getOneOf((Object[])new BasicSettlementRaidLevelEvent[]{new HumanSettlementRaidLevelEvent(), new AncientSkeletonRaidLevelEvent(), new FishianSettlementRaidLevelEvent(), new MummiesSettlementRaidLevelEvent(), new TheMafiaRaidLevelEvent(), new VoidApprenticesSettlementRaidLevelEvent(), new FrozenDwarvesSettlementRaidLevelEvent(), new ChickenPeopleSettlementRaidLevelEvent(), new PiratesSettlementRaidLevelEvent(), new NinjaSettlementRaidLevelEvent(), new VampiresSettlementRaidLevelEvent(), new RogueHuntersSettlementRaidLevelEvent()}) : (LevelData.hasCompletedQuestTier("piratecaptain") ? (SettlementRaidLevelEvent)GameRandom.globalRandom.getOneOf((Object[])new BasicSettlementRaidLevelEvent[]{new HumanSettlementRaidLevelEvent(), new VoidApprenticesSettlementRaidLevelEvent(), new FrozenDwarvesSettlementRaidLevelEvent(), new ChickenPeopleSettlementRaidLevelEvent(), new PiratesSettlementRaidLevelEvent(), new NinjaSettlementRaidLevelEvent(), new VampiresSettlementRaidLevelEvent(), new RogueHuntersSettlementRaidLevelEvent()}) : (LevelData.hasCompletedQuestTier("voidwizard") ? (SettlementRaidLevelEvent)GameRandom.globalRandom.getOneOf((Object[])new BasicSettlementRaidLevelEvent[]{new HumanSettlementRaidLevelEvent(), new ChickenPeopleSettlementRaidLevelEvent(), new PiratesSettlementRaidLevelEvent(), new NinjaSettlementRaidLevelEvent(), new VampiresSettlementRaidLevelEvent(), new RogueHuntersSettlementRaidLevelEvent()}) : (SettlementRaidLevelEvent)GameRandom.globalRandom.getOneOf((Object[])new BasicSettlementRaidLevelEvent[]{new HumanSettlementRaidLevelEvent(), new RogueHuntersSettlementRaidLevelEvent()})))) : RaidConfiguration.GetCustomRaid(LevelData, Options);
        } else if (Main.SettingsGetter.getBoolean("raids_enabled") && !Main.SettingsGetter.getBoolean("include_vanilla_raids")) {
            Event = RaidConfiguration.GetCustomRaid(LevelData, Options);
        }
    }

    public static SettlementRaidLevelEvent GetCustomRaid(ServerSettlementData LevelData, SettlementRaidOptions Options) {
        if (LevelData.hasCompletedQuestTier("fallenwizard")) {
            return (SettlementRaidLevelEvent)GameRandom.globalRandom.getOneOf((Object[])new SettlementRaidLevelEvent[]{new SpiderkinRaid(LevelData, Options), new SlimeCaveRaid(LevelData, Options), new GraveyardRaid(LevelData, Options)});
        }
        if (LevelData.hasCompletedQuestTier("pestwarden")) {
            return new AncientSkeletonRaid(LevelData, Options);
        }
        if (LevelData.hasCompletedQuestTier("piratecaptain")) {
            return (SettlementRaidLevelEvent)GameRandom.globalRandom.getOneOf((Object[])new SettlementRaidLevelEvent[]{new SkeletonRaid(LevelData, Options), new NinjaRaid(LevelData, Options)});
        }
        if (LevelData.hasCompletedQuestTier("swampguardian")) {
            return (SettlementRaidLevelEvent)GameRandom.globalRandom.getOneOf((Object[])new SettlementRaidLevelEvent[]{new PirateRaid(LevelData, Options), new RuneboundRaid(LevelData, Options)});
        }
        return new ZombieRaid(LevelData, Options);
    }
}

