/*
 * Decompiled with CFR 0.152.
 */
package NecesseExpanded.Patches.Gameplay;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.entity.mobs.friendly.human.HappinessModifier;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.SettlementBed;
import necesse.level.maps.levelData.settlementData.SettlementRoom;
import necesse.level.maps.levelData.settlementData.settler.DietThought;
import necesse.level.maps.levelData.settlementData.settler.FoodQuality;
import necesse.level.maps.levelData.settlementData.settler.PopulationThought;
import necesse.level.maps.levelData.settlementData.settler.RoomQuality;
import necesse.level.maps.levelData.settlementData.settler.RoomSize;
import necesse.level.maps.levelData.settlementData.settler.Settler;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=HumanMob.class, name="getHappinessModifiers", arguments={})
public class HappinessModifiersPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This HumanMob ThisSettler, @Advice.Return(readOnly=false) List<HappinessModifier> list) {
        ArrayList<HappinessModifier> Modifiers = new ArrayList<HappinessModifier>();
        if (ThisSettler.getWorldEntity() != null) {
            int NumberOfQuestsCompleted;
            ServerSettlementData LevelData;
            PopulationThought PopulationThought2;
            if (ThisSettler.lastFoodEaten != null && ThisSettler.lastFoodEaten.quality != null) {
                if (ThisSettler.lastFoodEaten.quality.happinessIncrease == 10) {
                    Modifiers.add(new HappinessModifier(8, (GameMessage)new LocalMessage("settlement", "simplemeal")));
                } else if (ThisSettler.lastFoodEaten.quality.happinessIncrease == 20) {
                    Modifiers.add(new HappinessModifier(12, (GameMessage)new LocalMessage("settlement", "finemeal")));
                } else if (ThisSettler.lastFoodEaten.quality.happinessIncrease == 35) {
                    Modifiers.add(new HappinessModifier(18, (GameMessage)new LocalMessage("settlement", "gourmetmeal")));
                } else if (ThisSettler.lastFoodEaten.quality.happinessIncrease == 40) {
                    Modifiers.add(new HappinessModifier(24, (GameMessage)new LocalMessage("settlement", "perfectmeal")));
                }
            } else {
                Modifiers.add(FoodQuality.noFoodModifier);
            }
            int differentFoodsEaten = (int)ThisSettler.recentFoodItemIDsEaten.stream().distinct().count();
            DietThought DietThought2 = Settler.getDietThought((int)differentFoodsEaten);
            if (DietThought2 != null) {
                Modifiers.add(DietThought2.getModifier());
            }
            if (ThisSettler.levelSettler != null) {
                HappinessModifier.bedOutsideModifier = new HappinessModifier(-10, (GameMessage)new LocalMessage("settlement", "bedoutside"));
                HappinessModifier.noBedModifier = new HappinessModifier(-20, (GameMessage)new LocalMessage("settlement", "nobed"));
                SettlementBed Bed = ThisSettler.levelSettler.getBed();
                if (Bed != null) {
                    SettlementRoom Room = Bed.getRoom();
                    if (Room != null) {
                        int RoomQuality2;
                        int RoomSize2;
                        int NumberOfOccupiedBeds = Bed.getRoom().getOccupiedBeds();
                        if (NumberOfOccupiedBeds > 1) {
                            Modifiers.add(new HappinessModifier(-5 * NumberOfOccupiedBeds, (GameMessage)new GameMessageBuilder().append("settlement", "sharingroom").append(" (" + (NumberOfOccupiedBeds - 1) + ")")));
                        }
                        if ((RoomSize2 = Room.getRoomSize()) > 0) {
                            RoomSize Size = Settler.getRoomSize((int)RoomSize2);
                            Modifiers.add(Size.getModifier());
                        }
                        if ((RoomQuality2 = Room.getFurnitureScore()) > 0) {
                            RoomQuality Quality = Settler.getRoomQuality((int)RoomQuality2);
                            Modifiers.add(Quality.getModifier());
                        }
                        if (Room.getRoomProperty("lights") <= 0) {
                            Modifiers.add(new HappinessModifier(-3, (GameMessage)new GameMessageBuilder().append("settlement", "roommissinglights")));
                        }
                        if (Room.getRoomProperty("outsidefloor") > 0) {
                            Modifiers.add(new HappinessModifier(-3, (GameMessage)new GameMessageBuilder().append("settlement", "roommissingfloor")));
                        }
                    } else {
                        Modifiers.add(HappinessModifier.bedOutsideModifier);
                    }
                } else {
                    Modifiers.add(HappinessModifier.noBedModifier);
                }
            }
            if ((PopulationThought2 = Settler.getPopulationThough((int)ThisSettler.levelSettler.data.countTotalSettlers())) != null) {
                Modifiers.add(PopulationThought2.getModifier());
            }
            if ((LevelData = ThisSettler.getSettlementServerData()) != null && (NumberOfQuestsCompleted = LevelData.getQuestTiersCompleted()) > 1) {
                Modifiers.add(new HappinessModifier(NumberOfQuestsCompleted - 1, (GameMessage)new GameMessageBuilder().append("settlement", "progression_bonus").append(" (" + NumberOfQuestsCompleted + ")")));
            }
            if (LevelData != null && LevelData.getHomestoneTile() != null) {
                Modifiers.add(new HappinessModifier(3, (GameMessage)new LocalMessage("settlement", "travel_bonus")));
            }
            if (LevelData != null) {
                if (LevelData.getNextRaidDifficultyMod() >= 1.25f) {
                    Modifiers.add(new HappinessModifier(6, (GameMessage)new LocalMessage("settlement", "well_defended_bonus")));
                } else if (LevelData.getNextRaidDifficultyMod() <= 0.75f) {
                    Modifiers.add(new HappinessModifier(0, (GameMessage)new LocalMessage("settlement", "poorly_defended_penalty")));
                }
            }
            if (LevelData != null) {
                Class<?> ClassObject = LevelData.getClass();
                try {
                    Field ClassField = ClassObject.getDeclaredField("nextRaid");
                    ClassField.setAccessible(true);
                    long RaidTimer = (Long)ClassField.get(LevelData);
                    if (RaidTimer >= (long)(ServerSettlementData.MIN_SECONDS_RAID_TIMER / 2) && LevelData.stats.spawned_raids.getTotalRaids() >= 1) {
                        Modifiers.add(new HappinessModifier(5, (GameMessage)new LocalMessage("settlement", "settlement_survived_raid")));
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException Ex) {
                    System.out.println(Ex);
                }
            }
            if (ThisSettler.buffManager.hasBuff("settler_death_penalty")) {
                Modifiers.add(new HappinessModifier(-5, (GameMessage)new LocalMessage("settlement", "recent_settler_death")));
            }
            list = Modifiers;
        }
    }
}

