/*
 * Decompiled with CFR 0.152.
 */
package NecesseExpanded.Patches.Gameplay;

import java.util.function.Predicate;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.registries.BiomeRegistry;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.biomes.FishingLootTable;
import necesse.level.maps.biomes.FishingSpot;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=Biome.class, name="getFishingLootTable", arguments={FishingSpot.class})
public class FishingLootTablePatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This Biome Biome2, @Advice.Argument(value=0) FishingSpot Spot, @Advice.Return(readOnly=false) FishingLootTable Loot) {
        if (Spot.tile.level.isIncursionLevel && Spot.tile.level.baseBiome == BiomeRegistry.CRYSTAL_HOLLOW) {
            Loot = new FishingLootTable().addWater(10, "pearlfish").addWater(20, "incursion_treasure_chest").addWater(40, "deep_treasure_chest");
        } else if (Spot.tile.level.isIncursionLevel && Spot.tile.level.baseBiome == BiomeRegistry.SLIME_CAVE) {
            Loot = new FishingLootTable().add(10, FishingLootTablePatch.SlimeTileCheck(), "slimefish").add(20, FishingLootTablePatch.SlimeTileCheck(), "incursion_treasure_chest").add(40, FishingLootTablePatch.SlimeTileCheck(), "deep_treasure_chest");
        } else if (Spot.tile.level.isIncursionLevel) {
            Loot = new FishingLootTable().addWater(10, "incursion_treasure_chest").addWater(40, "deep_treasure_chest");
        } else if (Spot.tile.level.getIslandDimension() == -2 && Spot.tile.level.baseBiome == BiomeRegistry.SNOW) {
            Loot = new FishingLootTable().addWater(40, "deep_treasure_chest").addWater(20, "heartfish").addWater(20, "glacierfish");
        } else if (Spot.tile.level.getIslandDimension() == -2) {
            Loot = new FishingLootTable().addWater(40, "deep_treasure_chest").addWater(20, "heartfish");
        }
    }

    public static Predicate<FishingSpot> SlimeTileCheck() {
        return Target -> Target.tile.tile.getStringID().equals("liquidslimetile");
    }
}

