/*
 * Decompiled with CFR 0.152.
 */
package NecesseExpanded.Events.Utils;

import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.levelEvent.explosionEvent.ExplosionEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.gfx.GameResources;

public class BrimstoneExplosionEvent
extends ExplosionEvent {
    public BrimstoneExplosionEvent() {
        this(0.0f, 0.0f, 40, new GameDamage(80.0f), true, 0.0f, null);
    }

    public BrimstoneExplosionEvent(float x, float y, int range, GameDamage damage, boolean destructive, float toolTier, Mob owner) {
        super(x, y, range, damage, destructive, toolTier, owner);
    }

    public BrimstoneExplosionEvent(float x, float y, int range, GameDamage damage, boolean destroysObjects, boolean destroysTiles, float toolTier, Mob owner) {
        super(x, y, range, damage, destroysObjects, destroysTiles, toolTier, owner);
    }

    protected GameDamage getTotalObjectDamage(float mod) {
        float objectMod = (float)Math.pow(mod, 0.7f) * 10.0f;
        return super.getTotalObjectDamage(mod).modDamage(objectMod);
    }

    protected void playExplosionEffects() {
        SoundManager.playSound((GameSound)GameResources.explosionHeavy, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(2.5f).pitch(1.5f));
        this.level.getClient().startCameraShake(this.x, this.y, 300, 40, 3.0f, 3.0f, true);
    }

    protected void onMobWasHit(Mob mob, float distance) {
        float mod = this.getDistanceMod(distance);
        GameDamage damage = this.getTotalMobDamage(mod);
        float knockback = (float)this.knockback * mod;
        mob.isServerHit(damage, (float)mob.getX() - this.x, (float)mob.getY() - this.y, knockback, (Attacker)this);
        mob.buffManager.addBuff(new ActiveBuff("ablaze", mob, 10000, (Attacker)this), true);
    }
}

