/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.utils;

import java.awt.geom.Line2D;
import java.util.function.Predicate;
import java.util.stream.Stream;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.engine.util.gameAreaSearch.GameAreaStream;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.leaves.HumanAngerTargetAINode;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rpgclasses.buffs.MarkedBuff;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.summons.damageable.DamageableFollowingMob;
import rpgclasses.mobs.summons.damageable.necrotic.NecroticFollowingMob;

public class RPGUtils {
    public static GameAreaStream<Mob> streamMobs(Mob attacker, int range) {
        return RPGUtils.streamMobs(attacker.getLevel(), attacker.x, attacker.y, range);
    }

    public static GameAreaStream<Mob> streamMobs(Level level, float x, float y, int range) {
        return level.entityManager.mobs.streamArea(x, y, range).filter(RPGUtils.isInRangeFilter(x, y, range));
    }

    public static GameAreaStream<PlayerMob> streamPlayers(Mob attacker, int range) {
        return RPGUtils.streamPlayers(attacker.getLevel(), attacker.x, attacker.y, range);
    }

    public static GameAreaStream<PlayerMob> streamPlayers(Level level, float x, float y, int range) {
        return level.entityManager.players.streamArea(x, y, range).filter(RPGUtils.isInRangeFilter(x, y, range));
    }

    public static Stream<ServerClient> streamDeathPlayers(Server server, int maxTime, LevelIdentifier levelIdentifier, Predicate<ServerClient> filter) {
        return server == null ? Stream.empty() : server.streamClients().filter(c -> c.playerMob != null && c.isDead() && c.isSamePlace(levelIdentifier)).filter(c -> {
            PlayerData playerData = PlayerDataList.getPlayerData(c.playerMob);
            return playerData != null && c.playerMob.getTime() - playerData.lastDeath <= (long)maxTime;
        }).filter(filter);
    }

    public static Stream<? extends ServerClient> streamDeathPlayers(Level level, int maxTime, Predicate<ServerClient> filter) {
        return RPGUtils.streamDeathPlayers(level.getServer(), maxTime, level.getIdentifier(), filter);
    }

    public static Stream<? extends ServerClient> streamDeathPlayers(Level level, float maxTime, Predicate<ServerClient> filter) {
        return RPGUtils.streamDeathPlayers(level, (int)(maxTime * 1000.0f), filter);
    }

    public static ServerClient lastDeathPlayer(Level level, float maxTime, Predicate<ServerClient> filter) {
        return RPGUtils.lastDeathPlayer(level, (int)(maxTime * 1000.0f), filter);
    }

    public static ServerClient lastDeathPlayer(Level level, int maxTime, Predicate<ServerClient> filter) {
        ServerClient[] bestHolder = new ServerClient[]{null};
        long[] bestTime = new long[]{0L};
        RPGUtils.streamDeathPlayers(level, maxTime, filter).forEach(serverClient -> {
            PlayerData playerData = PlayerDataList.getPlayerData(serverClient.playerMob);
            if (playerData != null && playerData.lastDeath > bestTime[0]) {
                bestTime[0] = playerData.lastDeath;
                bestHolder[0] = serverClient;
            }
        });
        return bestHolder[0];
    }

    public static GameAreaStream<Mob> streamMobsAndPlayers(Mob attacker, int range) {
        return RPGUtils.streamMobsAndPlayers(attacker.getLevel(), attacker.x, attacker.y, range);
    }

    public static GameAreaStream<Mob> streamMobsAndPlayers(Level level, float x, float y, int range) {
        return level.entityManager.streamAreaMobsAndPlayers(x, y, range).filter(RPGUtils.isInRangeFilter(x, y, range));
    }

    public static boolean isValidTarget(Mob attacker, Mob target) {
        return RPGUtils.isValidTarget(attacker.isPlayer ? ((PlayerMob)attacker).getNetworkClient() : null, attacker, target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidTarget(NetworkClient client, Mob attacker, Mob target) {
        if (!target.canTakeDamage()) {
            return false;
        }
        if (attacker.isPlayer) {
            if (target.isHostile) return target.canBeTargeted(attacker, client);
            if (!target.isHuman) return false;
            HumanAngerTargetAINode humanAngerHandler = (HumanAngerTargetAINode)target.ai.blackboard.getObject(HumanAngerTargetAINode.class, "humanAngerHandler");
            if (humanAngerHandler != null && humanAngerHandler.enemies.contains(attacker)) return target.canBeTargeted(attacker, client);
            return false;
        }
        if (!attacker.isHostile || target.isPlayer || target.isHuman) return target.canBeTargeted(attacker, client);
        return false;
    }

    public static Predicate<Mob> isValidTargetFilter(Mob attacker) {
        NetworkClient client = attacker.isPlayer ? ((PlayerMob)attacker).getNetworkClient() : null;
        return m -> RPGUtils.isValidTarget(client, attacker, m);
    }

    public static Predicate<Mob> isValidAttackerFilter(Mob target) {
        return m -> RPGUtils.isValidTarget(m, target);
    }

    public static boolean isInRange(float x, float y, int maxDist, Mob target) {
        return RPGUtils.isInRangeSq(x, y, maxDist * maxDist, target);
    }

    public static boolean isInRangeSq(float x, float y, int maxDistSq, Mob target) {
        float dy;
        float dx = (float)target.getX() - x;
        return dx * dx + (dy = (float)target.getY() - y) * dy <= (float)maxDistSq;
    }

    public static Predicate<Mob> isInRangeFilter(float x, float y, int maxDist) {
        int maxDistanceSq = maxDist * maxDist;
        return m -> RPGUtils.isInRangeSq(x, y, maxDistanceSq, m);
    }

    public static boolean isInVision(Level level, float x, float y, Mob target) {
        return RPGUtils.isInVision(level, x, y, new CollisionFilter().projectileCollision(), target);
    }

    public static boolean isInVision(Level level, float x, float y, CollisionFilter collisionFilter, Mob target) {
        return !level.collides((Line2D)new Line2D.Float(x, y, target.x, target.y), collisionFilter);
    }

    public static Predicate<Mob> inVisionFilter(Level level, float x, float y) {
        CollisionFilter collisionFilter = new CollisionFilter().projectileCollision();
        return m -> RPGUtils.isInVision(level, x, y, collisionFilter, m);
    }

    public static Predicate<Mob> isMarkedFilter(PlayerMob player) {
        return m -> MarkedBuff.isMarked(player, m);
    }

    public static boolean isFollower(Mob owner, Mob target) {
        return target.isFollowing() && target.getFollowingMob() == owner;
    }

    public static Predicate<Mob> isFollowerFilter(Mob owner) {
        return m -> RPGUtils.isFollower(owner, m);
    }

    public static boolean isDamageableFollower(Mob owner, Mob target) {
        return RPGUtils.isFollower(owner, target) && target instanceof DamageableFollowingMob;
    }

    public static Predicate<Mob> isDamageableFollowerFilter(Mob owner) {
        return m -> RPGUtils.isDamageableFollower(owner, m);
    }

    public static boolean isNecroticFollower(Mob owner, Mob target) {
        return RPGUtils.isFollower(owner, target) && target instanceof NecroticFollowingMob;
    }

    public static Predicate<Mob> isNecroticFollowerFilter(Mob owner) {
        return m -> RPGUtils.isNecroticFollower(owner, m);
    }

    public static Mob findBestTarget(@NotNull Mob mob, int distance) {
        return RPGUtils.findBestTarget(mob, mob.x, mob.y, distance, null);
    }

    public static Mob findBestTarget(@NotNull Mob mob, int distance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.findBestTarget(mob, mob.x, mob.y, distance, filter);
    }

    public static Mob findBestTarget(@NotNull Mob mob, float x, float y, int distance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.findBestTarget(mob.getLevel(), mob, x, y, distance, filter);
    }

    public static Mob findBestTarget(@NotNull Level level, @NotNull Mob attacker, float x, float y, int maxDistance, @Nullable Predicate<Mob> filter) {
        Mob[] bestHolder = new Mob[1];
        float[] bestDistSq = new float[]{Float.MAX_VALUE};
        int[] bestPriority = new int[]{-1};
        boolean attackerIsPlayer = attacker.isPlayer;
        RPGUtils.getAllTargets(level, attacker, x, y, maxDistance, filter).forEach(m -> {
            float dx = (float)m.getX() - x;
            float dy = (float)m.getY() - y;
            float distSq = dx * dx + dy * dy;
            int priority = 0;
            if (attackerIsPlayer) {
                if (MarkedBuff.isMarked((PlayerMob)attacker, m)) {
                    priority += 2;
                }
                if (m.isHostile) {
                    ++priority;
                }
            }
            if (priority > bestPriority[0] || priority == bestPriority[0] && distSq < bestDistSq[0]) {
                bestHolder[0] = m;
                bestDistSq[0] = distSq;
                bestPriority[0] = priority;
            }
        });
        return bestHolder[0];
    }

    public static Mob getRandomTarget(@NotNull Mob mob, int distance) {
        return RPGUtils.getRandomTarget(mob, distance, null);
    }

    public static Mob getRandomTarget(@NotNull Mob mob, int distance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.getRandomTarget(mob, mob.x, mob.y, distance, filter);
    }

    public static Mob getRandomTarget(@NotNull Mob mob, float x, float y, int distance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.getRandomTarget(mob.getLevel(), mob, x, y, distance, filter);
    }

    public static Mob getRandomTarget(@NotNull Level level, @NotNull Mob attacker, float x, float y, int maxDistance, @Nullable Predicate<Mob> filter) {
        Mob[] chosenHolder = new Mob[1];
        int[] count = new int[]{0};
        RPGUtils.getAllTargets(level, attacker, x, y, maxDistance, filter).forEach(m -> {
            count[0] = count[0] + 1;
            if (GameRandom.globalRandom.getChance(1.0f / (float)count[0])) {
                chosenHolder[0] = m;
            }
        });
        return chosenHolder[0];
    }

    public static boolean anyTarget(@NotNull Mob mob, int distance) {
        return RPGUtils.anyTarget(mob, distance, null);
    }

    public static boolean anyTarget(@NotNull Mob mob, int distance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.anyTarget(mob, mob.x, mob.y, distance, filter);
    }

    public static boolean anyTarget(@NotNull Mob mob, float x, float y, int distance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.anyTarget(mob.getLevel(), mob, x, y, distance, filter);
    }

    public static boolean anyTarget(@NotNull Level level, @NotNull Mob attacker, float x, float y, int maxDistance, @Nullable Predicate<Mob> filter) {
        NetworkClient client = attacker.isPlayer ? ((PlayerMob)attacker).getNetworkClient() : null;
        CollisionFilter collisionFilter = new CollisionFilter().projectileCollision();
        boolean hasFilter = filter != null;
        return RPGUtils.streamMobsAndPlayers(level, x, y, maxDistance).anyMatch(m -> {
            if (!RPGUtils.isValidTarget(client, attacker, m)) {
                return false;
            }
            if (!RPGUtils.isInVision(level, x, y, collisionFilter, m)) {
                return false;
            }
            return !hasFilter || filter.test((Mob)m);
        });
    }

    public static GameAreaStream<Mob> getAllTargets(@NotNull Mob mob, int distance) {
        return RPGUtils.getAllTargets(mob, distance, null);
    }

    public static GameAreaStream<Mob> getAllTargets(@NotNull Mob mob, int distance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.getAllTargets(mob, mob.x, mob.y, distance, filter);
    }

    public static GameAreaStream<Mob> getAllTargets(@NotNull Mob mob, float x, float y, int distance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.getAllTargets(mob.getLevel(), mob, x, y, distance, filter);
    }

    public static GameAreaStream<Mob> getAllTargets(@NotNull Level level, @NotNull Mob attacker, float x, float y, int maxDistance, @Nullable Predicate<Mob> filter) {
        NetworkClient client = attacker.isPlayer ? ((PlayerMob)attacker).getNetworkClient() : null;
        CollisionFilter collisionFilter = new CollisionFilter().projectileCollision();
        boolean hasFilter = filter != null;
        return RPGUtils.streamMobsAndPlayers(level, x, y, maxDistance).filter(m -> {
            if (!RPGUtils.isValidTarget(client, attacker, m)) {
                return false;
            }
            if (!RPGUtils.isInVision(level, x, y, collisionFilter, m)) {
                return false;
            }
            return !hasFilter || filter.test((Mob)m);
        });
    }

    public static boolean anyDamageableFollower(@NotNull Mob attacker, int maxDistance) {
        return RPGUtils.anyDamageableFollower(attacker.getLevel(), attacker, attacker.x, attacker.y, maxDistance, null);
    }

    public static boolean anyDamageableFollower(@NotNull Mob attacker, int maxDistance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.anyDamageableFollower(attacker.getLevel(), attacker, attacker.x, attacker.y, maxDistance, filter);
    }

    public static boolean anyDamageableFollower(@NotNull Level level, @NotNull Mob attacker, float x, float y, int maxDistance, @Nullable Predicate<Mob> filter) {
        boolean hasFilter = filter != null;
        return RPGUtils.streamMobs(level, x, y, maxDistance).anyMatch(m -> {
            if (!RPGUtils.isDamageableFollower(attacker, m)) {
                return false;
            }
            return !hasFilter || filter.test((Mob)m);
        });
    }

    public static Mob findClosestDamageableFollower(@NotNull Mob attacker, int maxDistance) {
        return RPGUtils.findClosestDamageableFollower(attacker.getLevel(), attacker, attacker.x, attacker.y, maxDistance, null);
    }

    public static Mob findClosestDamageableFollower(@NotNull Mob attacker, int maxDistance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.findClosestDamageableFollower(attacker.getLevel(), attacker, attacker.x, attacker.y, maxDistance, filter);
    }

    public static Mob findClosestDamageableFollower(@NotNull Level level, @NotNull Mob attacker, float x, float y, int maxDistance, @Nullable Predicate<Mob> filter) {
        Mob[] bestHolder = new Mob[1];
        float[] bestDistSq = new float[]{Float.MAX_VALUE};
        int[] bestPriority = new int[]{-1};
        boolean attackerIsPlayer = attacker.isPlayer;
        RPGUtils.getAllDamageableFollowers(level, attacker, x, y, maxDistance, filter).forEach(m -> {
            float dx = (float)m.getX() - x;
            float dy = (float)m.getY() - y;
            float distSq = dx * dx + dy * dy;
            int priority = 0;
            if (attackerIsPlayer) {
                if (MarkedBuff.isMarked((PlayerMob)attacker, m)) {
                    priority += 2;
                }
                if (m.isHostile) {
                    ++priority;
                }
            }
            if (priority > bestPriority[0] || priority == bestPriority[0] && distSq < bestDistSq[0]) {
                bestHolder[0] = m;
                bestDistSq[0] = distSq;
                bestPriority[0] = priority;
            }
        });
        return bestHolder[0];
    }

    public static GameAreaStream<Mob> getAllDamageableFollowers(@NotNull Mob attacker, int maxDistance) {
        return RPGUtils.getAllDamageableFollowers(attacker.getLevel(), attacker, attacker.x, attacker.y, maxDistance, null);
    }

    public static GameAreaStream<Mob> getAllDamageableFollowers(@NotNull Mob attacker, int maxDistance, @Nullable Predicate<Mob> filter) {
        return RPGUtils.getAllDamageableFollowers(attacker.getLevel(), attacker, attacker.x, attacker.y, maxDistance, filter);
    }

    public static GameAreaStream<Mob> getAllDamageableFollowers(@NotNull Level level, @NotNull Mob attacker, float x, float y, int maxDistance, @Nullable Predicate<Mob> filter) {
        boolean hasFilter = filter != null;
        return RPGUtils.streamMobs(level, x, y, maxDistance).filter(m -> {
            if (!RPGUtils.isDamageableFollower(attacker, m)) {
                return false;
            }
            return !hasFilter || filter.test((Mob)m);
        });
    }

    @FunctionalInterface
    public static interface TriRunnable<T, U, V> {
        public void run(T var1, U var2, V var3);

        default public TriRunnable<T, U, V> andThen(TriRunnable<? super T, ? super U, ? super V> after) {
            if (after == null) {
                throw new NullPointerException();
            }
            return (t, u, v) -> {
                this.run(t, u, v);
                after.run(t, u, v);
            };
        }
    }
}

