/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.utils;

import necesse.gfx.GameResources;
import org.lwjgl.opengl.GL11;

public class RPGRenderer {
    public static void drawArc(int centerX, int centerY, int innerRadius, int thickness, float start, float length, int segments, Alignment alignment, float red, float green, float blue, float alpha) {
        if (thickness < 1) {
            thickness = 1;
        }
        if (length < 1.0f) {
            length = 1.0f;
        }
        if (length > 360.0f) {
            length = 360.0f;
        }
        if (segments < 1) {
            segments = 1;
        }
        int outerRadius = innerRadius + thickness;
        float startAngleDeg = start;
        if (alignment != Alignment.START) {
            if (alignment == Alignment.CENTER) {
                startAngleDeg -= length / 2.0f;
            } else if (alignment == Alignment.END) {
                startAngleDeg -= length;
            }
        }
        GameResources.empty.bindTexture();
        GL11.glLoadIdentity();
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glBegin((int)5);
        for (int i = 0; i <= segments; ++i) {
            double t = (double)i / (double)segments;
            double angleRad = Math.toRadians((double)startAngleDeg + (double)length * t);
            double cos = Math.cos(angleRad);
            double sin = Math.sin(angleRad);
            double xOuter = (double)centerX + (double)outerRadius * cos;
            double yOuter = (double)centerY + (double)outerRadius * sin;
            double xInner = (double)centerX + (double)innerRadius * cos;
            double yInner = (double)centerY + (double)innerRadius * sin;
            GL11.glVertex2d((double)xOuter, (double)yOuter);
            GL11.glVertex2d((double)xInner, (double)yInner);
        }
        GL11.glEnd();
    }

    public static enum Alignment {
        START,
        CENTER,
        END;

    }
}

