/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.utils;

import aphorea.utils.area.AphArea;
import aphorea.utils.magichealing.AphMagicHealing;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.ToolItem;
import org.jetbrains.annotations.NotNull;

public class RPGArea
extends AphArea {
    public float attackerHealthMod = 1.0f;
    public Consumer<Mob> onTargetDamaged;
    public Map<String, GNDItemMap> buffsGND = new HashMap<String, GNDItemMap>();

    public RPGArea(float range, Color ... colors) {
        super(range, colors);
    }

    public RPGArea(float range, float alpha, Color ... colors) {
        super(range, alpha, colors);
    }

    public RPGArea setAttackerHealthMod(float attackerHealthMod) {
        this.attackerHealthMod = attackerHealthMod;
        return this;
    }

    public RPGArea addOnTargetDamaged(Consumer<Mob> onTargetDamaged) {
        this.onTargetDamaged = onTargetDamaged;
        return this;
    }

    public RPGArea addBuffGND(String buffID, GNDItemMap buffGND) {
        this.buffsGND.put(buffID, buffGND);
        return this;
    }

    public void applyHealth(Mob attacker, @NotNull Mob target, InventoryItem item, ToolItem toolItem) {
        int healing = this.areaHealing;
        if (target == attacker) {
            healing = (int)((float)healing * this.attackerHealthMod);
        }
        if (this.directExecuteHealing) {
            AphMagicHealing.healMobExecute((Mob)attacker, (Mob)target, (int)healing, (InventoryItem)item, (ToolItem)toolItem);
        } else {
            AphMagicHealing.healMob((Mob)attacker, (Mob)target, (int)healing, (InventoryItem)item, (ToolItem)toolItem);
        }
    }

    public void applyDamage(Mob attacker, @NotNull Mob target) {
        super.applyDamage(attacker, target);
        this.onTargetDamaged.accept(target);
    }

    public void applyBuffs(Mob attacker, @NotNull Mob target) {
        Arrays.stream(this.buffs).forEach(buffID -> {
            ActiveBuff activeBuff = new ActiveBuff(BuffRegistry.getBuff((String)buffID), target, this.buffDuration, (Attacker)attacker);
            GNDItemMap buffGND = this.buffsGND.get(buffID);
            if (buffGND != null) {
                activeBuff.getGndData().addAll(buffGND);
            }
            target.buffManager.addBuff(activeBuff, true);
        });
    }

    public void applyDebuffs(Mob attacker, @NotNull Mob target) {
        Arrays.stream(this.debuffs).forEach(debuffID -> {
            ActiveBuff activeBuff = new ActiveBuff(BuffRegistry.getBuff((String)debuffID), target, this.debuffDuration, (Attacker)attacker);
            GNDItemMap buffGND = this.buffsGND.get(debuffID);
            if (buffGND != null) {
                activeBuff.getGndData().addAll(buffGND);
            }
            target.buffManager.addBuff(activeBuff, true);
        });
    }
}

