/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.ui;

import necesse.engine.Settings;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.MainGameFormManager;
import necesse.gfx.forms.components.FormComponent;
import rpgclasses.data.PlayerData;
import rpgclasses.forms.rpgmenu.entries.ActiveSkillsEntry;
import rpgclasses.ui.CustomUIManager;
import rpgclasses.ui.RPGSkillUIForm;

public class RPGSkillUIManager
extends CustomUIManager<RPGSkillUIForm> {
    public final int skillSlot;

    public RPGSkillUIManager(int skillSlot) {
        this.skillSlot = skillSlot;
    }

    @Override
    public void setup(MainGameFormManager mainGameFormManager) {
        this.mainForm = (Form)mainGameFormManager.addComponent((FormComponent)new RPGSkillUIForm(this.skillSlot, 48, 48));
    }

    @Override
    public void frameTick(MainGameFormManager mainGameFormManager) {
        ((RPGSkillUIForm)this.mainForm).setHidden(mainGameFormManager.toolbar.isHidden() || this.skillSlot >= ActiveSkillsEntry.showManySlots);
    }

    @Override
    public void updatePosition(MainGameFormManager mainGameFormManager) {
        if (this.skillSlot < ActiveSkillsEntry.showManySlots) {
            int columns = ActiveSkillsEntry.showManySlots == 6 ? 1 : 2;
            int row = this.skillSlot / columns;
            int column = this.skillSlot % columns;
            GameWindow window = WindowManager.getWindow();
            ((RPGSkillUIForm)this.mainForm).setPosition(window.getHudWidth() - ((RPGSkillUIForm)this.mainForm).getWidth() - (Settings.UI.formSpacing + 20) - (columns - 1 - column) * 59, window.getHudHeight() - ((RPGSkillUIForm)this.mainForm).getHeight() - (Settings.UI.formSpacing + 20) - (5 - row) * 59);
        }
    }

    public static void updateContent(PlayerData playerData) {
        for (RPGSkillUIManager rpgSkill : CustomUIManager.rpgSkills) {
            ((RPGSkillUIForm)rpgSkill.mainForm).updateContent(playerData);
        }
    }

    public static void updateLevels(PlayerData playerData) {
        for (RPGSkillUIManager rpgSkill : CustomUIManager.rpgSkills) {
            ((RPGSkillUIForm)rpgSkill.mainForm).updateLevel(playerData);
        }
    }
}

