/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.ui;

import java.awt.Color;
import java.awt.Rectangle;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.item.Item;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.forms.rpgmenu.components.SkillIconComponent;

public class RPGSkillUIForm
extends Form {
    private final int slot;
    private EquippedActiveSkill equippedActiveSkill = new EquippedActiveSkill();
    private int activeSkillLevel;
    private SkillIconComponent skillIconComponent;

    public RPGSkillUIForm(int slot, int width, int height) {
        super("rpgskill" + slot + "ui", width, height);
        this.slot = slot;
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        int cooldownLeft;
        super.draw(tickManager, perspective, renderBox);
        FontOptions fontOptions = new FontOptions(12);
        fontOptions.color(Settings.UI.activeTextColor);
        FontManager.bit.drawString((float)(this.getX() + 2), (float)(this.getY() + 2), String.valueOf(this.slot + 1), fontOptions);
        if (!this.equippedActiveSkill.isEmpty() && ((cooldownLeft = this.equippedActiveSkill.getCooldownLeft(perspective.getTime())) > 0 || this.equippedActiveSkill.isInUse())) {
            String cooldownLeftString = this.equippedActiveSkill.getCooldownLeftString(cooldownLeft);
            FontOptions options = new FontOptions(Item.tipFontOptions);
            options.color(new Color(255, 102, 102));
            FontManager.bit.drawString((float)(this.getX() + 2), (float)(this.getY() + this.getHeight() - 12), cooldownLeftString, options);
        }
    }

    public void updateContent(PlayerData playerData) {
        EquippedActiveSkill newEquippedActiveSkill = playerData.equippedActiveSkills[this.slot];
        if (this.equippedActiveSkill.isEmpty() == newEquippedActiveSkill.isEmpty() || !this.equippedActiveSkill.isSameSkill(newEquippedActiveSkill)) {
            this.equippedActiveSkill = newEquippedActiveSkill;
            this.clearComponents();
            this.skillIconComponent = null;
            if (!this.equippedActiveSkill.isEmpty()) {
                this.updateLevel(playerData);
                this.skillIconComponent = (SkillIconComponent)this.addComponent((FormComponent)new SkillIconComponent(this.equippedActiveSkill.getActiveSkill(), this.activeSkillLevel, 0, 0, this.getWidth(), this.getHeight()));
            }
        }
    }

    public void updateLevel(PlayerData playerData) {
        if (this.equippedActiveSkill.isEmpty()) {
            this.activeSkillLevel = 0;
        } else {
            int newActiveSkillLevel = this.equippedActiveSkill.getActiveSkill().getLevel(playerData);
            if (this.skillIconComponent != null) {
                this.skillIconComponent.setSkillLevel(newActiveSkillLevel);
            }
            this.activeSkillLevel = newActiveSkillLevel;
        }
    }
}

