/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.ui;

import java.util.Collection;
import java.util.Iterator;
import necesse.engine.eventStatusBars.EventStatusBarManager;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.MainGameFormManager;
import necesse.gfx.forms.components.FormComponent;
import rpgclasses.data.PlayerData;
import rpgclasses.ui.CustomUIManager;
import rpgclasses.ui.ExpBarUIForm;

public class ExpBarUIManger
extends CustomUIManager<ExpBarUIForm> {
    public float barPercent;
    public boolean movedByInv = false;
    public boolean anyProgressBars = false;
    public boolean vertical = false;

    @Override
    public void setup(MainGameFormManager mainGameFormManager) {
        this.mainForm = (Form)mainGameFormManager.addComponent((FormComponent)new ExpBarUIForm("expbar", 408, 6));
    }

    @Override
    public void frameTick(MainGameFormManager mainGameFormManager) {
        boolean newAnyProgressBars;
        boolean anyUpdate = false;
        if (mainGameFormManager.isInventoryHidden() == this.movedByInv) {
            this.movedByInv = !this.movedByInv;
            anyUpdate = true;
        }
        if (this.anyProgressBars != (newAnyProgressBars = ExpBarUIManger.anyProgressBars(EventStatusBarManager.getStatusBars()))) {
            anyUpdate = true;
            this.anyProgressBars = newAnyProgressBars;
        }
        if (anyUpdate) {
            this.updateExpBarPosition(mainGameFormManager);
        }
        ((ExpBarUIForm)this.mainForm).setHidden(mainGameFormManager.toolbar.isHidden() || mainGameFormManager.inventory.isHidden() && newAnyProgressBars);
    }

    @Override
    public void updatePosition(MainGameFormManager mainGameFormManager) {
        this.updateExpBarPosition(mainGameFormManager);
    }

    public void updateExpBar(PlayerData playerData) {
        this.updateExpBar(playerData.getExpActual(), playerData.getExpNext());
    }

    public void updateExpBar(int expActual, int expNext) {
        this.barPercent = (float)expActual / (float)expNext;
    }

    public void updateExpBarPosition(MainGameFormManager mainGameFormManager) {
        if (mainGameFormManager.inventory.isHidden()) {
            this.vertical = false;
            ((ExpBarUIForm)this.mainForm).setPosition(mainGameFormManager.toolbar.getX(), mainGameFormManager.toolbar.getY() - 17);
            ((ExpBarUIForm)this.mainForm).setWidth(408);
            ((ExpBarUIForm)this.mainForm).setHeight(6);
        } else {
            this.vertical = true;
            ((ExpBarUIForm)this.mainForm).setPosition(mainGameFormManager.crafting.getX() + mainGameFormManager.crafting.getWidth() + 11, mainGameFormManager.crafting.getY());
            ((ExpBarUIForm)this.mainForm).setWidth(6);
            ((ExpBarUIForm)this.mainForm).setHeight(mainGameFormManager.crafting.getHeight());
        }
    }

    private static boolean anyProgressBars(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return !((Collection)iterable).isEmpty();
        }
        Iterator<?> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            Object ignored = iterator.next();
            return true;
        }
        return false;
    }
}

