/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.ui;

import java.awt.Point;
import java.awt.Rectangle;
import necesse.engine.GlobalData;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Input;
import necesse.engine.input.InputPosition;
import necesse.engine.network.client.Client;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.state.MainGame;
import necesse.engine.util.GameMath;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.gfx.Renderer;
import necesse.gfx.forms.Form;
import rpgclasses.mobs.mount.SkillTransformationMountSimpleAbilityMob;
import rpgclasses.mobs.mount.TransformationMountMob;
import rpgclasses.utils.RPGRenderer;

public class CursorCenterUIForm
extends Form {
    public CursorCenterUIForm(int width, int height) {
        super("transformationabilitiesui", width, height);
        this.canBePutOnTopByClick = false;
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        if (WindowManager.getWindow().getCursor() == null) {
            return;
        }
        Client client = ((MainGame)GlobalData.getCurrentState()).getClient();
        Mob mount2 = client.getPlayer().getMount();
        if (mount2 instanceof TransformationMountMob) {
            int size;
            float percentToMax;
            int timeToMax;
            int cursorWidth = this.getCursorWidth();
            int cursorHeight = this.getCursorHeight();
            Point cursorCenter = this.getCursorCenter(cursorWidth, cursorHeight);
            int reference = Math.max(cursorWidth, cursorHeight);
            int separation = (int)((float)reference * 0.6f);
            int thickness = (int)((float)reference * 0.4f);
            int length = 86;
            TransformationMountMob transformationMount = (TransformationMountMob)mount2;
            if (transformationMount.hasClick()) {
                timeToMax = (int)(transformationMount.nextRunClick - client.getPlayer().getTime());
                if (timeToMax <= 0) {
                    percentToMax = 0.0f;
                } else {
                    percentToMax = (float)timeToMax / (float)transformationMount.clickCooldown();
                    if (percentToMax > 1.0f) {
                        percentToMax = 1.0f;
                    }
                }
                size = (int)((1.0f - percentToMax) * (float)length);
                RPGRenderer.drawArc(cursorCenter.x, cursorCenter.y, separation + reference, thickness, 180.0f - (float)length / 2.0f, length, 20, RPGRenderer.Alignment.START, 1.0f, 0.0f, 1.0f, 0.2f);
                RPGRenderer.drawArc(cursorCenter.x, cursorCenter.y, separation + reference, thickness, 180.0f - (float)length / 2.0f, size, 20, RPGRenderer.Alignment.START, 1.0f, 0.0f, 1.0f, 1.0f);
            }
            if (transformationMount.hasSecondaryClick()) {
                timeToMax = (int)(transformationMount.nextRunSecondaryClick - client.getPlayer().getTime());
                if (timeToMax <= 0) {
                    percentToMax = 0.0f;
                } else {
                    percentToMax = (float)timeToMax / (float)transformationMount.secondaryClickCooldown();
                    if (percentToMax > 1.0f) {
                        percentToMax = 1.0f;
                    }
                }
                size = (int)((1.0f - percentToMax) * (float)length);
                RPGRenderer.drawArc(cursorCenter.x, cursorCenter.y, separation + reference, thickness, (float)length / 2.0f, length, 20, RPGRenderer.Alignment.END, 0.0f, 1.0f, 0.0f, 0.2f);
                RPGRenderer.drawArc(cursorCenter.x, cursorCenter.y, separation + reference, thickness, (float)length / 2.0f, size, 20, RPGRenderer.Alignment.END, 0.0f, 1.0f, 0.0f, 1.0f);
            }
            if (transformationMount.staminaBasedMountAbility() || transformationMount instanceof SkillTransformationMountSimpleAbilityMob) {
                boolean setRed = false;
                if (transformationMount.staminaBasedMountAbility()) {
                    ActiveBuff buff = perspective.buffManager.getBuff(BuffRegistry.STAMINA_BUFF);
                    if (buff != null && buff.getGndData().getBoolean("onCooldown")) {
                        setRed = true;
                    }
                    float stamina = StaminaBuff.getCurrentStamina((Mob)perspective);
                    stamina = GameMath.limit((float)stamina, (float)0.0f, (float)1.0f);
                    percentToMax = 1.0f - Math.abs(stamina - 1.0f);
                } else {
                    SkillTransformationMountSimpleAbilityMob skillMountSimpleAbilityMob = (SkillTransformationMountSimpleAbilityMob)transformationMount;
                    int timeToMax2 = (int)(skillMountSimpleAbilityMob.abilityCooldown - client.getPlayer().getTime());
                    if (timeToMax2 <= 0) {
                        percentToMax = 0.0f;
                    } else {
                        percentToMax = (float)timeToMax2 / (float)skillMountSimpleAbilityMob.mountAbilityCooldown();
                        if (percentToMax > 1.0f) {
                            percentToMax = 1.0f;
                        }
                    }
                }
                int size2 = (int)((1.0f - percentToMax) * (float)length);
                RPGRenderer.drawArc(cursorCenter.x, cursorCenter.y, separation + reference, thickness, 90.0f, length, 20, RPGRenderer.Alignment.CENTER, 1.0f, setRed ? 0.4f : 1.0f, setRed ? 0.4f : 1.0f, 0.2f);
                RPGRenderer.drawArc(cursorCenter.x, cursorCenter.y, separation + reference, thickness, 90.0f, size2, 20, RPGRenderer.Alignment.CENTER, 1.0f, setRed ? 0.4f : 1.0f, setRed ? 0.4f : 1.0f, 1.0f);
            }
        }
    }

    public Point getCursorCenter(int cursorWidth, int cursorHeight) {
        InputPosition mousePos = Input.mousePos;
        return new Point(mousePos.hudX + cursorWidth / 2, mousePos.hudY + cursorHeight / 2);
    }

    public int getCursorWidth() {
        return (int)(17.0f * Renderer.getCursorSizeZoom((int)Settings.cursorSize));
    }

    public int getCursorHeight() {
        return (int)(17.0f * Renderer.getCursorSizeZoom((int)Settings.cursorSize));
    }
}

