/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.registry;

import java.util.ArrayList;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.SimpleTrinketBuff;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.armorItem.ArmorModifiers;
import necesse.inventory.item.armorItem.ninja.NinjaHoodArmorItem;
import necesse.inventory.item.armorItem.ninja.NinjaRobeArmorItem;
import necesse.inventory.item.armorItem.ninja.NinjaShoesArmorItem;
import rpgclasses.content.player.Attribute;
import rpgclasses.items.AttributeRing;
import rpgclasses.items.RingsBox;
import rpgclasses.items.ScrollOfOblivion;
import rpgclasses.registry.RPGModifiers;

public class RPGItems {
    public static ArrayList<RingQuality> RING_QUALITIES = new ArrayList();

    public static void addRingQuality(RingQuality ringQuality) {
        RING_QUALITIES.add(ringQuality);
    }

    public static void registerCore() {
        ItemRegistry.registerItem((String)"scrollofoblivion", (Item)new ScrollOfOblivion(), (float)100.0f, (boolean)true);
        ItemRegistry.registerItem((String)"ringsbox", (Item)new RingsBox(), (float)-1.0f, (boolean)true);
        for (Attribute attribute : Attribute.attributesList) {
            ArrayList<String> prev = new ArrayList<String>();
            for (RingQuality ringQuality : RING_QUALITIES) {
                String itemID = attribute.stringID + ringQuality.stringID + "ring";
                String buffID = itemID + "buff";
                ItemRegistry.registerItem((String)itemID, (Item)new AttributeRing(ringQuality.rarity, buffID, ringQuality.enchantCost).addDisables(prev.toArray(new String[0])), (float)ringQuality.brokerValue, (boolean)true);
                BuffRegistry.registerBuff((String)buffID, (Buff)new SimpleTrinketBuff(new ModifierValue[]{new ModifierValue(attribute.ownModifier, (Object)ringQuality.points)}));
                prev.add(itemID);
            }
        }
        RPGItems.itemReworks();
    }

    public static void itemReworks() {
        ItemRegistry.replaceItem((String)"ninjahood", (Item)new NinjaHoodArmorItem(){

            public ArmorModifiers getArmorModifiers(InventoryItem item, Mob mob) {
                ArmorModifiers modifiers = super.getArmorModifiers(item, mob);
                modifiers.addModifier(RPGModifiers.THROWING_CRIT_DAMAGE, (Object)Float.valueOf(0.25f));
                return modifiers;
            }
        }, (float)120.0f, (boolean)true);
        ItemRegistry.replaceItem((String)"ninjarobe", (Item)new NinjaRobeArmorItem(){

            public ArmorModifiers getArmorModifiers(InventoryItem item, Mob mob) {
                ArmorModifiers modifiers = super.getArmorModifiers(item, mob);
                modifiers.addModifier(RPGModifiers.THROWING_CRIT_CHANCE, (Object)Float.valueOf(0.1f));
                return modifiers;
            }
        }, (float)200.0f, (boolean)true);
        ItemRegistry.replaceItem((String)"ninjashoes", (Item)new NinjaShoesArmorItem(){

            public ArmorModifiers getArmorModifiers(InventoryItem item, Mob mob) {
                ArmorModifiers modifiers = super.getArmorModifiers(item, mob);
                modifiers.addModifier(RPGModifiers.DODGE_CHANCE, (Object)Float.valueOf(0.05f));
                return modifiers;
            }
        }, (float)80.0f, (boolean)true);
    }

    static {
        RPGItems.addRingQuality(RingQuality.defaultDrop("wood", 2, 50.0f, 200, Item.Rarity.COMMON, 1, 11, 0.04f));
        RPGItems.addRingQuality(RingQuality.defaultDrop("copper", 4, 50.0f, 200, Item.Rarity.COMMON, 6, 17, 0.02f));
        RPGItems.addRingQuality(RingQuality.defaultDrop("iron", 6, 100.0f, 600, Item.Rarity.UNCOMMON, 12, 23, 0.01f));
        RPGItems.addRingQuality(RingQuality.defaultDrop("gold", 8, 200.0f, 1000, Item.Rarity.RARE, 18, Integer.MAX_VALUE, 0.005f));
    }

    public static class RingQuality {
        public String stringID;
        public int points;
        public float brokerValue;
        public int enchantCost;
        public Item.Rarity rarity;
        public boolean defaultDrop;
        public int minLevel;
        public int maxLevel;
        public float chance;

        private RingQuality(String stringID, int points, float brokerValue, int enchantCost, Item.Rarity rarity, boolean defaultDrop, int minLevel, int maxLevel, float chance) {
            this.stringID = stringID;
            this.points = points;
            this.brokerValue = brokerValue;
            this.enchantCost = enchantCost;
            this.rarity = rarity;
            this.defaultDrop = defaultDrop;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.chance = chance;
        }

        public static RingQuality defaultDrop(String stringID, int points, float brokerValue, int enchantCost, Item.Rarity rarity, int minLevel, int maxLevel, float chance) {
            return new RingQuality(stringID, points, brokerValue, enchantCost, rarity, true, minLevel, maxLevel, chance);
        }

        public static RingQuality customDrop(String stringID, int points, float brokerValue, int enchantCost, Item.Rarity rarity) {
            return new RingQuality(stringID, points, brokerValue, enchantCost, rarity, false, 0, 0, 0.0f);
        }
    }
}

