/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.registry;

import aphorea.registry.AphBuffs;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.GameRegistry;
import necesse.engine.registries.IDDataContainer;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.SimpleTrinketBuff;
import rpgclasses.buffs.CastingBuff;
import rpgclasses.buffs.ConstrainedBuff;
import rpgclasses.buffs.DarkCurseBuff;
import rpgclasses.buffs.IgnitedBuff;
import rpgclasses.buffs.MagicPoisonBuff;
import rpgclasses.buffs.MarkedBuff;
import rpgclasses.buffs.Passive.GrabbedObjectBuff;
import rpgclasses.buffs.Passive.HolyDamageDealtBuff;
import rpgclasses.buffs.Passive.ModifiersBuff;
import rpgclasses.buffs.Passive.OverLevelBuff;
import rpgclasses.buffs.Passive.TransformedBuff;
import rpgclasses.buffs.SimpleBuff;
import rpgclasses.buffs.TargetRangeTo100Buff;
import rpgclasses.buffs.TransformingBuff;
import rpgclasses.buffs.TrappedBuff;
import rpgclasses.registry.RPGModifiers;

public class RPGBuffs {
    public static List<String> debuffs = new ArrayList<String>();
    public static Buff TRAPPED;
    public static Buff MARKED;
    public static Buff DARK_CURSE;
    public static Buff MAGIC_POISON;
    public static Buff IGNITED;
    public static Buff CONSTRAINED;
    public static Buff TRANSFORMING;
    public static Buff CASTING;
    public static Buff AGGRESSIVE_BEES;
    public static Buff TARGET_RANGE_TO_100;

    public static void registerCore() {
        TRAPPED = new TrappedBuff();
        BuffRegistry.registerBuff((String)"trappedbuff", (Buff)TRAPPED);
        MARKED = new MarkedBuff();
        BuffRegistry.registerBuff((String)"markedbuff", (Buff)MARKED);
        DARK_CURSE = new DarkCurseBuff();
        BuffRegistry.registerBuff((String)"darkcursebuff", (Buff)DARK_CURSE);
        MAGIC_POISON = new MagicPoisonBuff();
        BuffRegistry.registerBuff((String)"magicpoisonbuff", (Buff)MAGIC_POISON);
        IGNITED = new IgnitedBuff();
        BuffRegistry.registerBuff((String)"ignitedbuff", (Buff)IGNITED);
        CONSTRAINED = new ConstrainedBuff();
        BuffRegistry.registerBuff((String)"constrainedbuff", (Buff)CONSTRAINED);
        TRANSFORMING = new TransformingBuff();
        BuffRegistry.registerBuff((String)"transformingbuff", (Buff)TRANSFORMING);
        CASTING = new CastingBuff();
        BuffRegistry.registerBuff((String)"castingbuff", (Buff)CASTING);
        AGGRESSIVE_BEES = new SimpleBuff();
        BuffRegistry.registerBuff((String)"aggresivebeesbuff", (Buff)AGGRESSIVE_BEES);
        TARGET_RANGE_TO_100 = new TargetRangeTo100Buff();
        BuffRegistry.registerBuff((String)"targetrangeto100", (Buff)TARGET_RANGE_TO_100);
        PASSIVES.MODIFIERS = new ModifiersBuff();
        BuffRegistry.registerBuff((String)"modifiersbuff", (Buff)PASSIVES.MODIFIERS);
        PASSIVES.HOLY_DAMAGE = new HolyDamageDealtBuff();
        BuffRegistry.registerBuff((String)"holydamagedealtbuff", (Buff)PASSIVES.HOLY_DAMAGE);
        PASSIVES.OVER_LEVEL = new OverLevelBuff();
        BuffRegistry.registerBuff((String)"overlevelbuff", (Buff)PASSIVES.OVER_LEVEL);
        PASSIVES.GRABBED_OBJECT = new GrabbedObjectBuff();
        BuffRegistry.registerBuff((String)"grabbedobjectbuff", (Buff)PASSIVES.GRABBED_OBJECT);
        PASSIVES.TRANSFORMED = new TransformedBuff();
        BuffRegistry.registerBuff((String)"transformedbuff", (Buff)PASSIVES.TRANSFORMED);
        RPGBuffs.buffReworks();
    }

    public static void buffReworks() {
        RPGBuffs.replaceBuff("vampiresgifttrinket", (Buff)new SimpleTrinketBuff("vampiresgift", new ModifierValue[]{new ModifierValue(BuffModifiers.SPEED, (Object)Float.valueOf(0.15f)), new ModifierValue(RPGModifiers.DODGE_CHANCE, (Object)Float.valueOf(0.03f))}));
        RPGBuffs.replaceBuff("trackerboottrinket", (Buff)new SimpleTrinketBuff("trackerboottip", new ModifierValue[]{new ModifierValue(BuffModifiers.SPEED, (Object)Float.valueOf(0.1f)), new ModifierValue(RPGModifiers.DODGE_CHANCE, (Object)Float.valueOf(0.02f))}));
    }

    public static void replaceBuff(String stringID, Buff buff) {
        try {
            Class<?> buffRegistryElementClass = Class.forName("necesse.engine.registries.BuffRegistry$BuffRegistryElement");
            Constructor<?> constructor = buffRegistryElementClass.getDeclaredConstructor(Buff.class);
            constructor.setAccessible(true);
            Object buffRegistryElement = constructor.newInstance(buff);
            Method replaceMethod = GameRegistry.class.getDeclaredMethod("replaceObj", String.class, IDDataContainer.class);
            replaceMethod.setAccessible(true);
            replaceMethod.invoke((Object)BuffRegistry.instance, stringID, buffRegistryElement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void applyStop(Mob target, float duration) {
        RPGBuffs.applyStop(target, (int)(duration * 1000.0f));
    }

    public static void applyStop(Mob target, int duration) {
        ActiveBuff ab = new ActiveBuff(AphBuffs.STOP, target, duration, null);
        target.buffManager.addBuff(ab, target.isServer());
    }

    public static void applyStun(Mob target, float duration) {
        RPGBuffs.applyStun(target, (int)(duration * 1000.0f));
    }

    public static void applyStun(Mob target, int duration) {
        ActiveBuff ab = new ActiveBuff(AphBuffs.STUN, target, duration, null);
        target.buffManager.addBuff(ab, target.isServer());
    }

    public static void purify(Mob target, boolean updatePacket) {
        ArrayList<String> buffsToRemove = new ArrayList<String>();
        for (ActiveBuff activeBuff : target.buffManager.getBuffs().values()) {
            String buffStringID = activeBuff.buff.getStringID();
            if (!debuffs.contains(buffStringID)) continue;
            buffsToRemove.add(buffStringID);
        }
        for (String id : buffsToRemove) {
            target.buffManager.removeBuff(id, updatePacket);
        }
    }

    static {
        debuffs.addAll(Arrays.stream(new String[]{"tremorhappening", "swampspores", "onfire", "ablaze", "brokenarmor", "spiderwebslow", "webpotionslow", "spidervenom", "necroticpoison", "necroticslow", "ivypoison", "widowpoison", "chilled", "freezing", "frostburn", "frostslow", "snowcovered", "snowcoveredslow", "flourcoveredslow", "haunted", "emeraldpoison", "spidercharmpoison", "slimepoison", "sandknifewound", "crystallize", "bloodgrimoiredebuff", "slimegreatbowdebuff", "crushingdarkness", "netted", "dryadhaunted", "dryadpossessed", "spirithaunted", "spiritpossessed", "stunneddamagetakenincreased", "spiritcorrupted", "stunbuff", "fallenstunbuff", "stickybuff", "honeyedbuff", "cursedbuff", "trappedbuff", "markedbuff", "darkcursebuff", "magicpoisonbuff", "ignitedbuff", "constrainedbuff"}).collect(Collectors.toList()));
    }

    public static class PASSIVES {
        public static ModifiersBuff MODIFIERS;
        public static HolyDamageDealtBuff HOLY_DAMAGE;
        public static OverLevelBuff OVER_LEVEL;
        public static GrabbedObjectBuff GRABBED_OBJECT;
        public static TransformedBuff TRANSFORMED;
    }
}

