/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.projectiles;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.followingProjectile.FollowingProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import rpgclasses.levelevents.RPGExplosionLevelEvent;
import rpgclasses.utils.RPGUtils;

public class PlasmaGrenadeProjectile
extends FollowingProjectile {
    public PlasmaGrenadeProjectile() {
    }

    public PlasmaGrenadeProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public void init() {
        super.init();
        this.turnSpeed = 0.5f;
        this.givesLight = true;
        this.height = 18.0f;
        this.trailOffset = 0.0f;
        this.setWidth(1.0f, true);
        this.piercing = 0;
        this.bouncing = 0;
        this.doesImpactDamage = false;
    }

    public Color getParticleColor() {
        return new Color(0, 255, 255);
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(0, 255, 255), 2.0f, 500, this.getHeight());
    }

    protected Color getWallHitColor() {
        return new Color(0, 255, 255);
    }

    public void updateTarget() {
        if (this.traveledDistance > 50.0f) {
            this.target = RPGUtils.findBestTarget(this.getOwner(), 1000);
        }
    }

    public float getTurnSpeed(int targetX, int targetY, float delta) {
        return super.getTurnSpeed(targetX, targetY, delta) * 0.002f * (this.traveledDistance - 50.0f);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        this.getLevel().entityManager.events.add((LevelEvent)new RPGExplosionLevelEvent(x, y, 50, this.getDamage(), this.getOwner(), false, new Color(0, 255, 255), new Color(0, 153, 153)));
    }
}

