/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.projectiles;

import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketChangeObject;
import necesse.engine.registries.ObjectRegistry;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.pickup.ItemPickupEntity;
import necesse.entity.projectile.Projectile;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameSprite;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class ObjectProjectile
extends Projectile {
    GameObject gameObject;

    public ObjectProjectile() {
    }

    public ObjectProjectile(Level level, Mob owner, GameObject gameObject, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
        this.gameObject = gameObject;
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.gameObject = ObjectRegistry.getObject((int)reader.getNextInt());
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.gameObject.getID());
    }

    public void init() {
        super.init();
        this.givesLight = false;
        this.height = 32.0f;
        this.heightBasedOnDistance = true;
        this.setWidth(20.0f, true);
    }

    public void remove() {
        if (this.isServer()) {
            boolean placed = false;
            if (!this.getLevel().isProtected) {
                for (int i = 0; i < 4; ++i) {
                    int tileX = (int)(this.x / 32.0f - this.dx / 2.0f * (float)i);
                    int tileY = (int)(this.y / 32.0f - this.dy / 2.0f * (float)i);
                    if (this.gameObject.canPlace(this.getLevel(), tileX, tileY, 2, true) != null) continue;
                    this.gameObject.placeObject(this.getLevel(), tileX, tileY, 2, true);
                    this.getServer().network.sendToAllClients((Packet)new PacketChangeObject(this.getLevel(), 0, tileX, tileY));
                    placed = true;
                    break;
                }
            }
            if (!placed) {
                this.getLevel().entityManager.pickups.add((Entity)new ItemPickupEntity(this.getLevel(), new InventoryItem((Item)this.gameObject.getObjectItem()), this.x, this.y, 0.0f, 0.0f));
            }
        }
        super.remove();
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables orderableDrawables, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera gameCamera, PlayerMob player) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = gameCamera.getDrawX(this.x);
            int drawY = (int)((float)gameCamera.getDrawY(this.y) - this.getHeight());
            GameSprite sprite = this.gameObject.getObjectItem().getWorldItemSprite(new InventoryItem((Item)this.gameObject.getObjectItem()), player);
            int spriteWidth = sprite.width * 2;
            int spriteHeight = sprite.height * 2;
            TextureDrawOptionsEnd options = sprite.initDraw().size(spriteWidth, spriteHeight).light(light).pos(drawX - spriteWidth / 2, drawY - spriteHeight / 2);
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (DrawOptions)options){
                final /* synthetic */ DrawOptions val$options;
                {
                    this.val$options = drawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
        }
    }
}

