/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.projectiles;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import rpgclasses.buffs.IgnitedBuff;

public class MiniFireballProjectile
extends Projectile {
    public MiniFireballProjectile() {
    }

    public MiniFireballProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public void init() {
        super.init();
        this.givesLight = true;
        this.height = 18.0f;
        this.trailOffset = 0.0f;
        this.setWidth(10.0f, true);
        this.piercing = 0;
        this.bouncing = 0;
    }

    public Color getParticleColor() {
        return new Color(255, 51, 0);
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(255, 51, 0), 20.0f, 200, this.getHeight());
    }

    protected Color getWallHitColor() {
        return new Color(255, 51, 0);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
    }

    protected void playHitSound(float x, float y) {
        SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.5f).pitch(1.5f));
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (mob != null) {
            IgnitedBuff.apply(this.getAttackOwner(), mob, this.getDamage().damage * 0.2f, 5.0f, false);
            if (mob.isClient()) {
                SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.5f).pitch(1.5f));
            }
        }
    }
}

