/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.projectiles;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import rpgclasses.levelevents.IceExplosionLevelEvent;

public class IceBallProjectile
extends Projectile {
    public IceBallProjectile() {
    }

    public IceBallProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public void init() {
        super.init();
        this.givesLight = true;
        this.height = 18.0f;
        this.trailOffset = 0.0f;
        this.setWidth(10.0f, true);
        this.piercing = 0;
        this.bouncing = 0;
        this.doesImpactDamage = false;
    }

    public Color getParticleColor() {
        return new Color(0, 204, 255);
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(0, 204, 255), 20.0f, 200, this.getHeight());
    }

    protected Color getWallHitColor() {
        return new Color(0, 204, 255);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        this.getLevel().entityManager.events.add((LevelEvent)new IceExplosionLevelEvent(x, y, 150, this.getDamage(), this.getOwner(), true));
    }
}

