/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.patches.ThrowingDamage;

import aphorea.items.tools.weapons.melee.dagger.AphDaggerToolItem;
import java.lang.reflect.Field;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.annotations.ModConstructorPatch;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.inventory.item.toolItem.projectileToolItem.throwToolItem.ThrowToolItem;
import necesse.inventory.item.toolItem.projectileToolItem.throwToolItem.boomerangToolItem.BoomerangToolItem;
import net.bytebuddy.asm.Advice;
import rpgclasses.registry.RPGDamageType;
import rpgclasses.settings.RPGSettings;

public class ToolItemPatches {
    public static boolean isThrowingDamage(ToolItem item, InventoryItem inventoryItem) {
        return item.getDamageType(inventoryItem) == RPGDamageType.THROWING && item.getFlatAttackDamage((InventoryItem)inventoryItem).damage > 0.0f;
    }

    public static boolean changeToThrowingDamage(ToolItem item) {
        if (item.getDamageType(null) == RPGDamageType.THROWING) {
            return false;
        }
        if (item instanceof ThrowToolItem) {
            return !(item instanceof BoomerangToolItem) || RPGSettings.settingsGetter.getBoolean("boomerangsDealThrowingDamage");
        }
        return false;
    }

    @ModMethodPatch(target=ToolItem.class, name="getTooltips", arguments={InventoryItem.class, PlayerMob.class, GameBlackboard.class})
    public static class getTooltips {
        @Advice.OnMethodEnter
        public static boolean onEnter(@Advice.This ToolItem This2) {
            if (ToolItemPatches.changeToThrowingDamage(This2)) {
                try {
                    Field damageTypeField = ToolItem.class.getDeclaredField("damageType");
                    damageTypeField.setAccessible(true);
                    damageTypeField.set(This2, RPGDamageType.THROWING);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        @Advice.OnMethodExit
        static void onExit(@Advice.This ToolItem This2, @Advice.Argument(value=0) InventoryItem inventoryItem, @Advice.Return(readOnly=false) ListGameTooltips tooltips) {
            if (ToolItemPatches.isThrowingDamage(This2, inventoryItem) || This2 instanceof AphDaggerToolItem) {
                tooltips.add(" ");
                tooltips.add(Localization.translate((String)"extraskilldesc", (String)"throwingdamage"));
            }
        }
    }

    @ModConstructorPatch(target=ToolItem.class, arguments={int.class})
    public static class ExampleConstructorPatch {
        @Advice.OnMethodExit
        static void onExit(@Advice.This ToolItem This2) {
            if (ToolItemPatches.changeToThrowingDamage(This2)) {
                try {
                    Field damageTypeField = ToolItem.class.getDeclaredField("damageType");
                    damageTypeField.setAccessible(true);
                    damageTypeField.set(This2, RPGDamageType.THROWING);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

