/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.patches;

import java.lang.reflect.Field;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameTexture.GameTexture;
import net.bytebuddy.asm.Advice;

public class StaminaBuffPatches {

    @ModMethodPatch(target=StaminaBuff.class, name="drawIcon", arguments={int.class, int.class, ActiveBuff.class})
    public static class drawIcon {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        static boolean onEnter(@Advice.This StaminaBuff This2, @Advice.Argument(value=0) int x, @Advice.Argument(value=1) int y, @Advice.Argument(value=2) ActiveBuff activeBuff) {
            GNDItemMap gndData = activeBuff.getGndData();
            boolean onCooldown = gndData.getBoolean("onCooldown");
            try {
                GameTexture texture = drawIcon.getTexture(This2, onCooldown);
                texture.initDraw().size(32, 32).draw(x, y);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            float stamina = gndData.getFloat("stamina");
            stamina = GameMath.limit((float)stamina, (float)0.0f, (float)1.0f);
            int staminaInt = (int)(Math.abs(stamina - 1.0f) * 100.0f * ((Float)activeBuff.owner.buffManager.getModifier(BuffModifiers.STAMINA_CAPACITY)).floatValue());
            staminaInt = Math.max(staminaInt, onCooldown ? 0 : 1);
            String text = staminaInt + "%";
            int width = FontManager.bit.getWidthCeil(text, Buff.durationFontOptions);
            FontManager.bit.drawString((float)(x + 16 - width / 2), (float)(y + 30), text, Buff.durationFontOptions);
            return true;
        }

        public static GameTexture getTexture(StaminaBuff This2, boolean onCooldown) throws NoSuchFieldException, IllegalAccessException {
            Field field = onCooldown ? StaminaBuff.class.getDeclaredField("cooldownTexture") : Buff.class.getDeclaredField("iconTexture");
            field.setAccessible(true);
            GameTexture texture = (GameTexture)field.get(This2);
            return texture;
        }
    }
}

