/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.patches;

import java.util.HashSet;
import necesse.engine.GlobalData;
import necesse.engine.input.Input;
import necesse.engine.input.InputPosition;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.state.MainGame;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.pickup.ItemPickupEntity;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.forms.components.FormExpressionWheel;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.objectItem.ObjectItem;
import necesse.level.maps.Level;
import net.bytebuddy.asm.Advice;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.TransformationMountMob;
import rpgclasses.packets.TransformationAbility1Packet;
import rpgclasses.packets.TransformationAbility2Packet;
import rpgclasses.registry.RPGControls;

public class PlayerMobPatches {

    @ModMethodPatch(target=PlayerMob.class, name="tickControls", arguments={MainGame.class, boolean.class, GameCamera.class})
    public static class tickControls {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob player, @Advice.Argument(value=0) MainGame mainGame, @Advice.Argument(value=1) boolean isGameTick, @Advice.Argument(value=2) GameCamera camera) {
            int mouseLevelY;
            int mouseLevelX;
            InputPosition inputPosition;
            TransformationMountMob transformation;
            Mob mount2;
            if (RPGControls.TRANSFORMATION_ABILITY_1.isDown() && player != null && (mount2 = player.getMount()) instanceof TransformationMountMob && (transformation = (TransformationMountMob)mount2).canRunClick(player)) {
                inputPosition = Input.mousePos;
                mouseLevelX = inputPosition.sceneX + camera.getX();
                mouseLevelY = inputPosition.sceneY + camera.getY();
                transformation.clickRunClient(player.getLevel(), mouseLevelX, mouseLevelY, player);
                player.getClient().network.sendPacket((Packet)new TransformationAbility1Packet(player.getClient().getSlot(), mouseLevelX, mouseLevelY));
            }
            if (RPGControls.TRANSFORMATION_ABILITY_2.isDown() && player != null && (mount2 = player.getMount()) instanceof TransformationMountMob && (transformation = (TransformationMountMob)mount2).canRunSecondaryClick(player)) {
                inputPosition = Input.mousePos;
                mouseLevelX = inputPosition.sceneX + camera.getX();
                mouseLevelY = inputPosition.sceneY + camera.getY();
                transformation.secondaryClickRunClient(player.getLevel(), mouseLevelX, mouseLevelY, player);
                player.getClient().network.sendPacket((Packet)new TransformationAbility2Packet(player.getClient().getSlot(), mouseLevelX, mouseLevelY));
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="startExpression", arguments={FormExpressionWheel.Expression.class})
    public static class startExpression {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        static boolean onEnter(@Advice.This PlayerMob This2, @Advice.Argument(value=0) FormExpressionWheel.Expression expression) {
            Client client;
            if (This2.isClient() && (client = ((MainGame)GlobalData.getCurrentState()).getClient()).getPlayer() == This2) {
                int skillSlot = expression == FormExpressionWheel.Expression.SAD ? 0 : (expression == FormExpressionWheel.Expression.SURPRISED ? 1 : (expression == FormExpressionWheel.Expression.ANGRY ? 2 : 3));
                PlayerData playerData = PlayerDataList.getPlayerData(This2);
                EquippedActiveSkill equippedActiveSkill = playerData.equippedActiveSkills[skillSlot];
                equippedActiveSkill.tryClientRun(This2, skillSlot);
            }
            return true;
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="onDeath", arguments={Attacker.class, HashSet.class})
    public static class onDeath {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2) {
            PlayerData playerData = PlayerDataList.getPlayerData(This2);
            if (playerData != null) {
                playerData.lastDeath = This2.getTime();
                if (playerData.grabbedObject != null) {
                    Level level = This2.getLevel();
                    if (!level.isProtected && playerData.grabbedObject.canPlace(level, This2.getTileX(), This2.getTileY(), 2, true) == null) {
                        playerData.grabbedObject.placeObject(level, This2.getTileX(), This2.getTileY(), 2, true);
                    } else {
                        ObjectItem objectItem = playerData.grabbedObject.getObjectItem();
                        if (objectItem != null) {
                            level.entityManager.pickups.add((Entity)new ItemPickupEntity(level, new InventoryItem((Item)objectItem), This2.x, This2.y, 0.0f, 0.0f));
                        }
                    }
                }
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="restore", arguments={})
    public static class restore {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2) {
            PlayerData playerData = PlayerDataList.getPlayerData(This2);
            if (playerData != null) {
                playerData.updateAllBuffs(This2);
                for (EquippedActiveSkill equippedActiveSkill : playerData.equippedActiveSkills) {
                    equippedActiveSkill.restartCooldown();
                }
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="applySpawnPacket", arguments={PacketReader.class})
    public static class applySpawnPacket {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2, @Advice.Argument(value=0) PacketReader reader) {
            if (reader.hasNext()) {
                PlayerData playerData = PlayerData.applyPacket(reader);
                PlayerDataList.setPlayerData(playerData.playerName, playerData, This2.isServer());
                playerData.updateAllBuffs(This2);
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="setupSpawnPacket", arguments={PacketWriter.class})
    public static class setupSpawnPacket {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2, @Advice.Argument(value=0) PacketWriter writer) {
            PlayerData playerData = PlayerDataList.getPlayerData(This2.playerName, This2.isServer());
            if (playerData != null) {
                playerData.setupPacket(writer);
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="addSaveData", arguments={SaveData.class})
    public static class addSaveData {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2, @Advice.Argument(value=0) SaveData saveData) {
            PlayerData player = PlayerDataList.getPlayerData(This2);
            if (player != null) {
                player.saveData(saveData);
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="applyLoadData", arguments={LoadData.class})
    public static class applyLoadData {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2, @Advice.Argument(value=0) LoadData loadData) {
            PlayerData playerData = PlayerDataList.initPlayerData(This2);
            playerData.loadData(This2, loadData);
        }
    }
}

