/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.patches;

import java.util.HashSet;
import java.util.Objects;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.server.ServerClient;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.hostile.SandwormBody;
import necesse.entity.mobs.hostile.SlimeWormBody;
import necesse.entity.mobs.hostile.bosses.PestWardenBody;
import necesse.entity.mobs.hostile.bosses.SwampGuardianBody;
import necesse.level.maps.Level;
import net.bytebuddy.asm.Advice;
import rpgclasses.buffs.Interfaces.TransformationClassBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.MobData;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.SkillTransformationMountMob;
import rpgclasses.mobs.mount.TransformationMountMob;
import rpgclasses.packets.UpdateClientEquippedActiveSkillsPacket;
import rpgclasses.settings.RPGSettings;

public class MobPatches {
    public static GameMessage getLocalization(Mob mob, MobData mobData, GameMessage gameMessage) {
        String extra = "";
        if (mobData.isUndead()) {
            extra = extra + Localization.translate((String)"mobtrait", (String)"undead") + " - ";
        }
        if (mobData.isDemonic()) {
            extra = extra + Localization.translate((String)"mobtrait", (String)"demonic") + " - ";
        }
        return new StaticMessage(extra + Localization.translate((String)"mob", (String)(mob.isBoss() ? "rpgmobname" : "rpgmobnamecolor"), (Object[])new Object[]{"name", gameMessage.translate(), "level", mobData.level, "class", mobData.mobClass.getName(), "color", mobData.mobClass.color}));
    }

    @ModMethodPatch(target=PestWardenBody.class, name="getLocalization", arguments={})
    public static class getLocalizationPestWardenBody {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PestWardenBody This2, @Advice.Return(readOnly=false) GameMessage gameMessage) {
            MobData mobData = MobData.getMob((Mob)This2);
            if (mobData != null) {
                gameMessage = MobPatches.getLocalization((Mob)This2, mobData, gameMessage);
            }
        }
    }

    @ModMethodPatch(target=SandwormBody.class, name="getLocalization", arguments={})
    public static class getLocalizationSandwormBody {
        @Advice.OnMethodExit
        static void onExit(@Advice.This SandwormBody This2, @Advice.Return(readOnly=false) GameMessage gameMessage) {
            MobData mobData = MobData.getMob((Mob)This2);
            if (mobData != null) {
                gameMessage = MobPatches.getLocalization((Mob)This2, mobData, gameMessage);
            }
        }
    }

    @ModMethodPatch(target=SlimeWormBody.class, name="getLocalization", arguments={})
    public static class getLocalizationSlimeWormBody {
        @Advice.OnMethodExit
        static void onExit(@Advice.This SlimeWormBody This2, @Advice.Return(readOnly=false) GameMessage gameMessage) {
            MobData mobData = MobData.getMob((Mob)This2);
            if (mobData != null) {
                gameMessage = MobPatches.getLocalization((Mob)This2, mobData, gameMessage);
            }
        }
    }

    @ModMethodPatch(target=SwampGuardianBody.class, name="getLocalization", arguments={})
    public static class getLocalizationSwampGuardianBody {
        @Advice.OnMethodExit
        static void onExit(@Advice.This SwampGuardianBody This2, @Advice.Return(readOnly=false) GameMessage gameMessage) {
            MobData mobData = MobData.getMob((Mob)This2);
            if (mobData != null) {
                gameMessage = MobPatches.getLocalization((Mob)This2, mobData, gameMessage);
            }
        }
    }

    @ModMethodPatch(target=Mob.class, name="getLocalization", arguments={})
    public static class getLocalization {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Mob This2, @Advice.Return(readOnly=false) GameMessage gameMessage) {
            MobData mobData = MobData.getMob(This2);
            if (mobData != null) {
                gameMessage = MobPatches.getLocalization(This2, mobData, gameMessage);
            }
        }
    }

    @ModMethodPatch(target=Mob.class, name="mount", arguments={Mob.class, boolean.class, float.class, float.class, boolean.class})
    public static class mount {
        @Advice.OnMethodExit
        public static void onExit(@Advice.This Mob This2, @Advice.Argument(value=0) Mob mount2) {
            if (This2.isPlayer && This2.isServer()) {
                PlayerMob player = (PlayerMob)This2;
                PlayerData playerData = PlayerDataList.getPlayerData(player);
                EquippedActiveSkill equippedActiveSkill = playerData.getInUseActiveSkillSlot();
                if (!(equippedActiveSkill == null || !(equippedActiveSkill.getActiveSkill() instanceof SimpleTranformationActiveSkill) || mount2 instanceof SkillTransformationMountMob && ((SimpleTranformationActiveSkill)equippedActiveSkill.getActiveSkill()).getMobStringID().equals(mount2.getStringID()))) {
                    equippedActiveSkill.startCooldown(player, playerData, player.getTime(), equippedActiveSkill.getActiveSkill().getLevel(playerData));
                    This2.getServer().network.sendToAllClients((Packet)new UpdateClientEquippedActiveSkillsPacket(playerData));
                }
                if (mount2 instanceof TransformationMountMob) {
                    TransformationClassBuff.apply((Mob)player);
                }
            }
        }
    }

    @ModMethodPatch(target=Mob.class, name="onDeath", arguments={Attacker.class, HashSet.class})
    public static class MobDeathPatch {
        @Advice.OnMethodExit
        public static void onExit(@Advice.This Mob This2, @Advice.Argument(value=0) Attacker attacker, @Advice.Argument(value=1) HashSet<Attacker> attackers) {
            MobData mobData = MobData.getMob(This2);
            if (This2.isServer() && mobData != null && !MobData.mobsForcedBossClass.contains(This2.getStringID()) && (!Objects.equals(mobData.mobClass.stringID, "boss") || This2.isBoss())) {
                float exp = (float)mobData.level * mobData.mobClass.expMod * GameRandom.globalRandom.getFloatBetween(0.9f, 1.1f) * RPGSettings.experienceMod();
                exp = (float)Math.pow(exp, 1.5);
                HashSet<PlayerMob> processedPlayers = new HashSet<PlayerMob>();
                for (Attacker attackerMob : attackers) {
                    int finalExp;
                    PlayerMob player;
                    if (attackerMob.getAttackOwner() == null || !attackerMob.getAttackOwner().isPlayer || processedPlayers.contains(player = (PlayerMob)attackerMob.getAttackOwner())) continue;
                    processedPlayers.add(player);
                    ServerClient serverClient = player.getServerClient();
                    if (serverClient.characterStats().mob_kills.getKills(This2.getStringID()) == 0) {
                        finalExp = (int)(exp * RPGSettings.firstKillBonus());
                        serverClient.sendChatMessage((GameMessage)new LocalMessage("message", "newmobkill", new Object[]{"mob", mobData.realName(), "exp", finalExp}));
                    } else {
                        finalExp = (int)exp;
                    }
                    if (finalExp <= 0) continue;
                    PlayerData playerData = PlayerDataList.getPlayerData(player);
                    playerData.modExpSendPacket(serverClient, finalExp);
                }
            }
        }
    }

    @ModMethodPatch(target=Mob.class, name="applySpawnPacket", arguments={PacketReader.class})
    public static class applySpawnPacket {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Mob This2, @Advice.Argument(value=0) PacketReader reader) {
            MobData.applySpawnPacket(reader, This2);
        }
    }

    @ModMethodPatch(target=Mob.class, name="setupSpawnPacket", arguments={PacketWriter.class})
    public static class setupSpawnPacket {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Mob This2, @Advice.Argument(value=0) PacketWriter writer) {
            MobData mobData = MobData.getMob(This2);
            if (mobData != null) {
                mobData.setupSpawnPacket(writer);
            }
        }
    }

    @ModMethodPatch(target=Mob.class, name="applyLoadData", arguments={LoadData.class})
    public static class applyLoadData {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Mob This2, @Advice.Argument(value=0) LoadData save) {
            MobData.loadData(save, This2);
        }
    }

    @ModMethodPatch(target=Mob.class, name="addSaveData", arguments={SaveData.class})
    public static class addSaveData {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Mob This2, @Advice.Argument(value=0) SaveData save) {
            MobData mobData = MobData.getMob(This2);
            if (mobData != null) {
                mobData.saveData(save);
            }
        }
    }

    @ModMethodPatch(target=Mob.class, name="setLevel", arguments={Level.class})
    public static class setLevel {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Mob This2) {
            MobData.initMob(This2);
        }
    }

    @ModMethodPatch(target=Mob.class, name="init", arguments={})
    public static class init {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Mob This2) {
            MobData.initMob(This2);
        }
    }
}

