/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.patches;

import necesse.engine.GlobalData;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.client.Client;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.state.MainGame;
import necesse.entity.mobs.Attacker;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.SniperProjectileToolItem;
import net.bytebuddy.asm.Advice;
import rpgclasses.registry.RPGModifiers;

public class ItemsPatches {

    @ModMethodPatch(target=ToolItem.class, name="getAttackRange", arguments={InventoryItem.class})
    public static class getAttackRange {
        @Advice.OnMethodExit
        static void onExit(@Advice.This ToolItem This2, @Advice.Argument(value=0) InventoryItem inventoryItem, @Advice.Return(readOnly=false) int range) {
            if (This2.getDamageType(inventoryItem) == DamageTypeRegistry.RANGED) {
                range = (int)((float)range * inventoryItem.getGndData().getFloat("rangedRangeMod", 1.0f));
            }
        }
    }

    @ModMethodPatch(target=ToolItem.class, name="getKnockback", arguments={InventoryItem.class, Attacker.class})
    public static class getKnockback {
        @Advice.OnMethodExit
        static void onExit(@Advice.This ToolItem This2, @Advice.Argument(value=0) InventoryItem inventoryItem, @Advice.Argument(value=1) Attacker attacker) {
            if (This2.getDamageType(inventoryItem) == DamageTypeRegistry.RANGED && attacker.getFirstPlayerOwner() != null) {
                inventoryItem.getGndData().setFloat("rangedRangeMod", ((Float)attacker.getFirstPlayerOwner().buffManager.getModifier(RPGModifiers.RANGED_WEAPONS_RANGE)).floatValue());
            }
        }
    }

    @ModMethodPatch(target=SniperProjectileToolItem.class, name="zoomAmount", arguments={})
    public static class zoomAmountSniper {
        @Advice.OnMethodExit
        static void onExit(@Advice.This SniperProjectileToolItem This2, @Advice.Return(readOnly=false) float zoom) {
            Client client = ((MainGame)GlobalData.getCurrentState()).getClient();
            if (client != null) {
                zoom += ((Float)client.getPlayer().buffManager.getModifier(RPGModifiers.RANGED_WEAPONS_ZOOM)).floatValue();
            }
        }
    }

    @ModMethodPatch(target=Item.class, name="zoomAmount", arguments={})
    public static class zoomAmount {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Item This2, @Advice.Return(readOnly=false) float zoom) {
            Client client = ((MainGame)GlobalData.getCurrentState()).getClient();
            if (client != null && This2 instanceof ToolItem && ((ToolItem)This2).getDamageType(null) == DamageTypeRegistry.RANGED) {
                zoom = ((Float)client.getPlayer().buffManager.getModifier(RPGModifiers.RANGED_WEAPONS_ZOOM)).floatValue();
            }
        }
    }
}

