/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.patches;

import java.lang.reflect.Field;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.entity.mobs.EquipmentBuffManager;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import net.bytebuddy.asm.Advice;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public class EquipmentBuffManagerPatches {

    @ModMethodPatch(target=EquipmentBuffManager.class, name="updateTrinketBuffs", arguments={boolean.class})
    public static class updateTrinketBuffs {
        @Advice.OnMethodExit
        static void onExit(@Advice.This EquipmentBuffManager This2) {
            try {
                Field ownerField = EquipmentBuffManager.class.getDeclaredField("owner");
                ownerField.setAccessible(true);
                Mob owner = (Mob)ownerField.get(This2);
                if (owner.isPlayer) {
                    PlayerMob player = (PlayerMob)owner;
                    PlayerData playerData = PlayerDataList.getPlayerData(player);
                    player.buffManager.forceUpdateBuffs();
                    if (playerData != null) {
                        playerData.updateModifiersBuff(player);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ModMethodPatch(target=EquipmentBuffManager.class, name="updateEquipmentBuff", arguments={})
    public static class updateEquipmentBuff {
        @Advice.OnMethodExit
        static void onExit(@Advice.This EquipmentBuffManager This2) {
            try {
                PlayerMob player;
                PlayerData playerData;
                Field ownerField = EquipmentBuffManager.class.getDeclaredField("owner");
                ownerField.setAccessible(true);
                Mob owner = (Mob)ownerField.get(This2);
                if (owner.isPlayer && (playerData = PlayerDataList.getPlayerData(player = (PlayerMob)owner)) != null) {
                    playerData.updateAllBuffs(player);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

