/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.patches;

import java.awt.Rectangle;
import necesse.engine.GlobalData;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.client.Client;
import necesse.engine.state.MainGame;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.hostile.HostileMob;
import necesse.gfx.gameTexture.GameSprite;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.MobSpawnItem;
import net.bytebuddy.asm.Advice;
import rpgclasses.data.MobData;
import rpgclasses.registry.RPGModifiers;

public class EntityPatches {
    public boolean shouldDrawOnMap() {
        return false;
    }

    @ModMethodPatch(target=Entity.class, name="drawOnMap", arguments={TickManager.class, Client.class, int.class, int.class, double.class, Rectangle.class, boolean.class})
    public static class drawOnMap {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Entity This2, @Advice.Argument(value=0) TickManager tickManager, @Advice.Argument(value=1) Client client, @Advice.Argument(value=2) int x, @Advice.Argument(value=3) int y, @Advice.Argument(value=4) double tileScale, @Advice.Argument(value=5) Rectangle drawBounds, @Advice.Argument(value=6) boolean isMinimap) {
            if (!(This2 instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)This2;
            MobSpawnItem spawnItem = mob.getSpawnItem();
            if (spawnItem == null) {
                return;
            }
            GameSprite gameSprite = spawnItem.getItemSprite(new InventoryItem((Item)spawnItem), client.getPlayer());
            if (gameSprite == null) {
                return;
            }
            if (((Float)client.getPlayer().buffManager.getModifier(RPGModifiers.MOB_DETECTION_RANGE)).floatValue() < client.getPlayer().getDistance(mob)) {
                return;
            }
            int drawX = x - gameSprite.width / 2;
            int drawY = y - gameSprite.height / 2;
            gameSprite.initDraw().draw(drawX, drawY);
        }
    }

    @ModMethodPatch(target=Entity.class, name="shouldDrawOnMap", arguments={})
    public static class shouldDrawOnMap {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Entity This2, @Advice.Return(readOnly=false) boolean draw) {
            Client client;
            if (draw) {
                return;
            }
            if (!(This2 instanceof Mob)) {
                return;
            }
            if (GlobalData.getCurrentState() instanceof MainGame && (client = ((MainGame)GlobalData.getCurrentState()).getClient()) != null) {
                draw = ((Float)client.getPlayer().buffManager.getModifier(RPGModifiers.MOB_DETECTION_RANGE)).floatValue() >= client.getPlayer().getDistance((Mob)This2);
            }
        }
    }

    @ModMethodPatch(target=Entity.class, name="resetUniqueID", arguments={GameRandom.class})
    public static class resetUniqueID {
        @Advice.OnMethodExit
        static void onExit(@Advice.This Entity This2) {
            if (This2 instanceof HostileMob) {
                MobData.initMob((Mob)((HostileMob)This2));
            }
        }
    }
}

