/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import java.util.ArrayList;
import java.util.List;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public class UpdateClientMasteryPacket
extends Packet {
    public final String playerName;
    public final List<Integer> masterySkills;

    public UpdateClientMasteryPacket(byte[] data) {
        super(data);
        int[] masteryArray;
        PacketReader reader = new PacketReader((Packet)this);
        this.playerName = reader.getNextString();
        this.masterySkills = new ArrayList<Integer>();
        int masterySize = reader.getNextInt();
        for (int i : masteryArray = reader.getNextInts(masterySize)) {
            this.masterySkills.add(i);
        }
    }

    public UpdateClientMasteryPacket(PlayerData playerData) {
        this.playerName = playerData.playerName;
        this.masterySkills = playerData.masterySkills;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextString(this.playerName);
        int[] masteryArray = this.masterySkills.stream().mapToInt(Integer::intValue).toArray();
        writer.putNextInt(masteryArray.length);
        writer.putNextInts(masteryArray);
    }

    public void processClient(NetworkPacket packet, Client client) {
        PlayerData playerData = PlayerDataList.getPlayerData(this.playerName, false);
        if (playerData != null) {
            playerData.setMasterySkills(this.masterySkills);
        }
    }
}

