/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import java.util.Objects;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.ui.CustomUIManager;

public class UpdateClientExpPacket
extends Packet {
    public final String playerName;
    public final int exp;

    public UpdateClientExpPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.playerName = reader.getNextString();
        this.exp = reader.getNextInt();
    }

    public UpdateClientExpPacket(PlayerData playerData) {
        this.playerName = playerData.playerName;
        this.exp = playerData.getBaseExp();
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextString(this.playerName);
        writer.putNextInt(this.exp);
    }

    public void processClient(NetworkPacket packet, Client client) {
        PlayerData playerData;
        if (client.getPlayer() != null && (playerData = PlayerDataList.getPlayerData(this.playerName, false)) != null) {
            playerData.loadDataExp(this.exp);
            if (Objects.equals(client.getPlayer().playerName, this.playerName)) {
                CustomUIManager.expBar.updateExpBar(playerData);
            }
        }
    }
}

